/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSException;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.RecipientOperator;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcePasswordRecipient;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.io.MacOutputStream;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.MacCalculator;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Mac;

public class JcePasswordAuthenticatedRecipient
extends JcePasswordRecipient {
    public JcePasswordAuthenticatedRecipient(char[] cArray) {
        super(cArray);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2) throws CMSException {
        final Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray, byArray2);
        final Mac mac = this.helper.createContentMac(key, algorithmIdentifier2);
        return new RecipientOperator(new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public GenericKey getKey() {
                return new JceGenericKey(algorithmIdentifier2, key);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream(mac);
            }

            @Override
            public byte[] getMac() {
                return mac.doFinal();
            }
        });
    }
}

