/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.encodings;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.AsymmetricBlockCipher;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Digest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.util.DigestFactory;
import com.timevale.esign.paas.tgtext.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash;
    private Digest mgf1Hash;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this(asymmetricBlockCipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest, byArray);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.mgf1Hash = digest2;
        this.defHash = new byte[digest.getDigestSize()];
        digest.reset();
        if (byArray != null) {
            digest.update(byArray, 0, byArray.length);
        }
        digest.doFinal(this.defHash, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
        } else {
            this.random = new SecureRandom();
        }
        this.engine.init(bl2, cipherParameters);
        this.forEncryption = bl2;
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n2 - 1 - 2 * this.defHash.length;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n2;
        }
        return n2 - 1 - 2 * this.defHash.length;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n2, n3);
        }
        return this.decodeBlock(byArray, n2, n3);
    }

    public byte[] encodeBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        if (n3 > this.getInputBlockSize()) {
            throw new DataLengthException("input data too long");
        }
        byte[] byArray2 = new byte[this.getInputBlockSize() + 1 + 2 * this.defHash.length];
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        byArray2[byArray2.length - n3 - 1] = 1;
        System.arraycopy(this.defHash, 0, byArray2, this.defHash.length, this.defHash.length);
        byte[] byArray3 = new byte[this.defHash.length];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, 0, byArray3.length, byArray2.length - this.defHash.length);
        for (n4 = this.defHash.length; n4 != byArray2.length; ++n4) {
            int n5 = n4;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray4[n4 - this.defHash.length]);
        }
        System.arraycopy(byArray3, 0, byArray2, 0, this.defHash.length);
        byArray4 = this.maskGeneratorFunction1(byArray2, this.defHash.length, byArray2.length - this.defHash.length, this.defHash.length);
        for (n4 = 0; n4 != this.defHash.length; ++n4) {
            int n6 = n4;
            byArray2[n6] = (byte)(byArray2[n6] ^ byArray4[n4]);
        }
        return this.engine.processBlock(byArray2, 0, byArray2.length);
    }

    public byte[] decodeBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        int n5;
        int n6;
        byte[] byArray2 = this.engine.processBlock(byArray, n2, n3);
        byte[] byArray3 = new byte[this.engine.getOutputBlockSize()];
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        int n7 = byArray3.length < 2 * this.defHash.length + 1 ? 1 : 0;
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, this.defHash.length, byArray3.length - this.defHash.length, this.defHash.length);
        for (n6 = 0; n6 != this.defHash.length; ++n6) {
            int n8 = n6;
            byArray3[n8] = (byte)(byArray3[n8] ^ byArray4[n6]);
        }
        byArray4 = this.maskGeneratorFunction1(byArray3, 0, this.defHash.length, byArray3.length - this.defHash.length);
        for (n6 = this.defHash.length; n6 != byArray3.length; ++n6) {
            int n9 = n6;
            byArray3[n9] = (byte)(byArray3[n9] ^ byArray4[n6 - this.defHash.length]);
        }
        n6 = 0;
        for (n5 = 0; n5 != this.defHash.length; ++n5) {
            if (this.defHash[n5] == byArray3[this.defHash.length + n5]) continue;
            n6 = 1;
        }
        n5 = byArray3.length;
        for (n4 = 2 * this.defHash.length; n4 != byArray3.length; ++n4) {
            if (!(byArray3[n4] != 0 & n5 == byArray3.length)) continue;
            n5 = n4;
        }
        n4 = (n5 > byArray3.length - 1 ? 1 : 0) | (byArray3[n5] != 1 ? 1 : 0);
        ++n5;
        if ((n6 | n7 | n4) != 0) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] byArray5 = new byte[byArray3.length - n5];
        System.arraycopy(byArray3, n5, byArray5, 0, byArray5.length);
        return byArray5;
    }

    private void ItoOSP(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.mgf1Hash.getDigestSize()];
        byte[] byArray4 = new byte[4];
        this.mgf1Hash.reset();
        for (n5 = 0; n5 < n4 / byArray3.length; ++n5) {
            this.ItoOSP(n5, byArray4);
            this.mgf1Hash.update(byArray, n2, n3);
            this.mgf1Hash.update(byArray4, 0, byArray4.length);
            this.mgf1Hash.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * byArray3.length, byArray3.length);
        }
        if (n5 * byArray3.length < n4) {
            this.ItoOSP(n5, byArray4);
            this.mgf1Hash.update(byArray, n2, n3);
            this.mgf1Hash.update(byArray4, 0, byArray4.length);
            this.mgf1Hash.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * byArray3.length, byArray2.length - n5 * byArray3.length);
        }
        return byArray2;
    }
}

