/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.operator.bc;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.ExtendedDigest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Signer;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.signers.DSADigestSigner;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.signers.DSASigner;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.util.PublicKeyFactory;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new DSASigner(), extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

