/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.x509;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.CertificatePair;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.util.JcaJceHelper;
import com.timevale.esign.paas.tgtext.bouncycastle.jce.provider.X509CertificateObject;
import com.timevale.esign.paas.tgtext.bouncycastle.x509.ExtCertificateEncodingException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;

public class X509CertificatePair {
    private final JcaJceHelper bcHelper = new BCJcaJceHelper();
    private X509Certificate forward;
    private X509Certificate reverse;

    public X509CertificatePair(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        this.forward = x509Certificate;
        this.reverse = x509Certificate2;
    }

    public X509CertificatePair(CertificatePair certificatePair) throws CertificateParsingException {
        if (certificatePair.getForward() != null) {
            this.forward = new X509CertificateObject(certificatePair.getForward());
        }
        if (certificatePair.getReverse() != null) {
            this.reverse = new X509CertificateObject(certificatePair.getReverse());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        Certificate certificate = null;
        Certificate certificate2 = null;
        try {
            if (this.forward != null && (certificate = Certificate.getInstance(new ASN1InputStream(this.forward.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for forward");
            }
            if (this.reverse != null && (certificate2 = Certificate.getInstance(new ASN1InputStream(this.reverse.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for reverse");
            }
            return new CertificatePair(certificate, certificate2).getEncoded("DER");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExtCertificateEncodingException(illegalArgumentException.toString(), illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new ExtCertificateEncodingException(iOException.toString(), iOException);
        }
    }

    public X509Certificate getForward() {
        return this.forward;
    }

    public X509Certificate getReverse() {
        return this.reverse;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof X509CertificatePair)) {
            return false;
        }
        X509CertificatePair x509CertificatePair = (X509CertificatePair)object;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.forward != null) {
            bl3 = this.forward.equals(x509CertificatePair.forward);
        } else if (x509CertificatePair.forward != null) {
            bl3 = false;
        }
        if (this.reverse != null) {
            bl2 = this.reverse.equals(x509CertificatePair.reverse);
        } else if (x509CertificatePair.reverse != null) {
            bl2 = false;
        }
        return bl3 && bl2;
    }

    public int hashCode() {
        int n2 = -1;
        if (this.forward != null) {
            n2 ^= this.forward.hashCode();
        }
        if (this.reverse != null) {
            n2 *= 17;
            n2 ^= this.reverse.hashCode();
        }
        return n2;
    }
}

