/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.text.pdf.security;

import com.timevale.esign.paas.tgtext.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.esign.paas.tgtext.text.pdf.security.ab;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;

public class e {
    public static String a(X509Certificate x509Certificate, Collection<CRL> collection, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        if (x509Certificate.hasUnsupportedCriticalExtension()) {
            for (String object : x509Certificate.getCriticalExtensionOIDs()) {
                if ("2.5.29.15".equals(object) && x509Certificate.getKeyUsage()[0]) continue;
                try {
                    if ("2.5.29.37".equals(object) && x509Certificate.getExtendedKeyUsage().contains("1.3.6.1.5.5.7.3.8")) {
                        continue;
                    }
                }
                catch (CertificateParsingException certificateParsingException) {
                    // empty catch block
                }
                return "Has unsupported critical extension";
            }
        }
        try {
            x509Certificate.checkValidity(calendar.getTime());
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        if (collection != null) {
            for (CRL cRL : collection) {
                if (!cRL.isRevoked(x509Certificate)) continue;
                return "Certificate revoked";
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static List<ab> a(Certificate[] certificateArray, KeyStore keyStore, Collection<CRL> collection, Calendar calendar) {
        ArrayList<ab> arrayList = new ArrayList<ab>();
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            int n2;
            Object object;
            X509Certificate x509Certificate = (X509Certificate)certificateArray[i2];
            String string = e.a(x509Certificate, collection, calendar);
            if (string != null) {
                arrayList.add(new ab(x509Certificate, string));
            }
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry((String)object)) continue;
                    X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate((String)object);
                    if (e.a(x509Certificate2, collection, calendar) != null) continue;
                    {
                        catch (Exception exception) {}
                    }
                    try {
                        x509Certificate.verify(x509Certificate2.getPublicKey());
                        return arrayList;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (n2 = 0; n2 < certificateArray.length; ++n2) {
                if (n2 == i2) continue;
                object = (X509Certificate)certificateArray[n2];
                try {
                    x509Certificate.verify(((Certificate)object).getPublicKey());
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n2 != certificateArray.length) continue;
            arrayList.add(new ab(x509Certificate, "Cannot be verified against the KeyStore or the certificate chain"));
        }
        if (arrayList.size() == 0) {
            arrayList.add(new ab(null, "Invalid state. Possible circular certificate chain"));
        }
        return arrayList;
    }

    public static List<ab> a(Certificate[] certificateArray, KeyStore keyStore, Calendar calendar) {
        return e.a(certificateArray, keyStore, null, calendar);
    }

    public static boolean a(BasicOCSPResp basicOCSPResp, KeyStore keyStore, String string) {
        if (string == null) {
            string = "BC";
        }
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                try {
                    String string2 = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry(string2)) continue;
                    X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
                    if (!basicOCSPResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(string).build(x509Certificate.getPublicKey()))) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean a(TimeStampToken timeStampToken, KeyStore keyStore, String string) {
        if (string == null) {
            string = "BC";
        }
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                try {
                    String string2 = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry(string2)) continue;
                    X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
                    timeStampToken.isSignatureValid(new JcaSimpleSignerInfoVerifierBuilder().setProvider(string).build(x509Certificate));
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

