/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.timevale.esign.paas.tech.bean.bean.AccountBean;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.OrganRegTypeEnum;
import com.timevale.esign.paas.tech.util.ValidateUtil;
import com.timevale.esign.paas.tech.util.ValidationUtil;
import com.timevale.seal.sdk.util.StringUtils;
import esign.utils.exception.SuperException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OrganizeParam
extends AccountBean {
    private OrganRegTypeEnum regType;
    private String orgCode;

    public OrganRegTypeEnum getRegType() {
        return this.regType;
    }

    public void setRegType(OrganRegTypeEnum regType) {
        this.regType = regType;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @Override
    public void check() throws SuperException {
        super.check();
        ValidationUtil.check(StringUtils.isBlank(this.orgCode), ErrorException.ADD_ACCOUNT_ERROR.e("orgCode\u4e0d\u80fd\u4e3a\u7a7a"));
        ValidationUtil.check(this.regType == null, ErrorException.ADD_ACCOUNT_ERROR.e("regType\u4e0d\u80fd\u4e3a\u7a7a"));
        ValidationUtil.check(this.getName().length() > 60 || this.getName().length() < 2, ErrorException.ADD_ACCOUNT_ERROR.e("\u4f01\u4e1a\u59d3\u540d\u53ea\u652f\u63012\u523060\u4e2a\u5b57\u7b26"));
        boolean bl2 = true;
        switch (this.regType) {
            case MERGE: {
                bl2 = ValidateUtil.orgCodeValid(this.orgCode);
                break;
            }
            case REGCODE: {
                bl2 = ValidateUtil.regCodeValid(this.orgCode);
                break;
            }
        }
        ValidationUtil.check(!bl2, ErrorException.ADD_ACCOUNT_ERROR.e("\u4f01\u4e1a\u8bc1\u4ef6\u53f7\u4e0e\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d"));
    }
}

