/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.guava.common.collect.Lists;
import com.timevale.guava.common.collect.Maps;
import com.timevale.seal.sdk.util.StringUtils;
import java.util.List;
import java.util.Map;

public enum AllIdNoTypeEnum {
    MAINLAND(19),
    HONGKONG(17),
    MACAO(17),
    TAIWAN(18),
    PASSPORT(13),
    OTHER(23),
    MERGE(11),
    REGCODE(12);

    private int val;
    static Map<String, AllIdNoTypeEnum> items;
    static Map<Integer, AllIdNoTypeEnum> valueItems;

    private AllIdNoTypeEnum(int val) {
        this.val = val;
    }

    public int val() {
        return this.val;
    }

    public static boolean valid(String type) {
        if (StringUtils.isBlank(type)) {
            return true;
        }
        return items.containsKey(type);
    }

    public static List<AllIdNoTypeEnum> personIdNoTypes() {
        return Lists.newArrayList(MAINLAND, HONGKONG, MACAO, TAIWAN, PASSPORT, OTHER);
    }

    public static List<AllIdNoTypeEnum> orgCodeTypes() {
        return Lists.newArrayList(MERGE, REGCODE, OTHER);
    }

    public static AllIdNoTypeEnum getByVal(Integer val) {
        return valueItems.getOrDefault(val, OTHER);
    }

    public static AllIdNoTypeEnum getByName(String name) {
        return items.get(name);
    }

    static {
        items = Maps.newHashMap();
        valueItems = Maps.newHashMap();
        for (AllIdNoTypeEnum allIdNoTypeEnum : AllIdNoTypeEnum.values()) {
            items.put(allIdNoTypeEnum.name(), allIdNoTypeEnum);
            valueItems.put(allIdNoTypeEnum.val(), allIdNoTypeEnum);
        }
    }
}

