/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.ec.i;
import com.timevale.esign.paas.tech.util.SM2Constant;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Helper {
    private static Logger LOGGER = LoggerFactory.getLogger(SM2Helper.class);

    public static i parsePublicKey(Certificate cert) throws IOException, CertificateException, NoSuchProviderException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
        DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
        byte[] byArray = dERBitString.getEncoded();
        byte[] byArray2 = new byte[65];
        System.arraycopy(byArray, 3, byArray2, 0, byArray2.length);
        return new i(SM2Helper.getPublicKeyFromByte(byArray2));
    }

    public static ECPoint getPublicKeyFromByte(byte[] data) {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        System.arraycopy(data, 1, byArray, 0, 32);
        System.arraycopy(data, 33, byArray2, 0, 32);
        new BigInteger(1, byArray);
        new BigInteger(1, byArray2);
        return SM2Constant.x9ECParameters.getCurve().decodePoint(data);
    }
}

