/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.annotations.GwtIncompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.AbstractMultiset;
import com.timevale.guava.common.collect.Count;
import com.timevale.guava.common.collect.ForwardingSet;
import com.timevale.guava.common.collect.Iterators;
import com.timevale.guava.common.collect.Multiset;
import com.timevale.guava.common.collect.Multisets;
import com.timevale.guava.common.primitives.Ints;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private transient Map<E, Count> backingMap;
    private transient long size;
    @GwtIncompatible(value="not needed in emulated source.")
    private static final long serialVersionUID = -2250766705698539974L;

    protected AbstractMapBasedMultiset(Map<E, Count> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
        this.size = super.size();
    }

    Map<E, Count> backingMap() {
        return this.backingMap;
    }

    void setBackingMap(Map<E, Count> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        return super.entrySet();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        final Iterator<Map.Entry<E, Count>> iterator = this.backingMap.entrySet().iterator();
        return new Iterator<Multiset.Entry<E>>(){
            Map.Entry<E, Count> toRemove;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                Map.Entry entry;
                this.toRemove = entry = (Map.Entry)iterator.next();
                return new Multisets.AbstractEntry<E>(){

                    @Override
                    public E getElement() {
                        return entry.getKey();
                    }

                    @Override
                    public int getCount() {
                        Count count;
                        int n2 = ((Count)entry.getValue()).get();
                        if (n2 == 0 && (count = (Count)AbstractMapBasedMultiset.this.backingMap.get(this.getElement())) != null) {
                            n2 = count.get();
                        }
                        return n2;
                    }
                };
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                AbstractMapBasedMultiset.this.size -= this.toRemove.getValue().getAndSet(0);
                iterator.remove();
                this.toRemove = null;
            }
        };
    }

    @Override
    public void clear() {
        for (Count count : this.backingMap.values()) {
            count.set(0);
        }
        this.backingMap.clear();
        this.size = 0L;
    }

    @Override
    int distinctElements() {
        return this.backingMap.size();
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public Iterator<E> iterator() {
        return new MapBasedMultisetIterator();
    }

    @Override
    public int count(@Nullable Object element) {
        try {
            Count count = this.backingMap.get(element);
            return count == null ? 0 : count.get();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    @Override
    public int add(@Nullable E element, int occurrences) {
        int n2;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        Count count = this.backingMap.get(element);
        if (count == null) {
            n2 = 0;
            this.backingMap.put(element, new Count(occurrences));
        } else {
            n2 = count.get();
            long l2 = (long)n2 + (long)occurrences;
            Preconditions.checkArgument(l2 <= Integer.MAX_VALUE, "too many occurrences: %s", l2);
            count.getAndAdd(occurrences);
        }
        this.size += (long)occurrences;
        return n2;
    }

    @Override
    public int remove(@Nullable Object element, int occurrences) {
        int n2;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        Count count = this.backingMap.get(element);
        if (count == null) {
            return 0;
        }
        int n3 = count.get();
        if (n3 > occurrences) {
            n2 = occurrences;
        } else {
            n2 = n3;
            this.backingMap.remove(element);
        }
        count.addAndGet(-n2);
        this.size -= (long)n2;
        return n3;
    }

    @Override
    public int setCount(E element, int count) {
        int n2;
        Multisets.checkNonnegative(count, "count");
        if (count == 0) {
            Count count2 = this.backingMap.remove(element);
            n2 = AbstractMapBasedMultiset.getAndSet(count2, count);
        } else {
            Count count3 = this.backingMap.get(element);
            n2 = AbstractMapBasedMultiset.getAndSet(count3, count);
            if (count3 == null) {
                this.backingMap.put(element, new Count(count));
            }
        }
        this.size += (long)(count - n2);
        return n2;
    }

    private static int getAndSet(Count i2, int count) {
        if (i2 == null) {
            return 0;
        }
        return i2.getAndSet(count);
    }

    private int removeAllOccurrences(@Nullable Object element, Map<E, Count> map) {
        Count count = map.remove(element);
        if (count == null) {
            return 0;
        }
        int n2 = count.getAndSet(0);
        this.size -= (long)n2;
        return n2;
    }

    @Override
    Set<E> createElementSet() {
        return new MapBasedElementSet(this.backingMap);
    }

    @GwtIncompatible(value="java.io.ObjectStreamException")
    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    class MapBasedElementSet
    extends ForwardingSet<E> {
        private final Map<E, Count> map;
        private final Set<E> delegate;

        MapBasedElementSet(Map<E, Count> map) {
            this.map = map;
            this.delegate = map.keySet();
        }

        @Override
        protected Set<E> delegate() {
            return this.delegate;
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator iterator = this.map.entrySet().iterator();
            return new Iterator<E>(){
                Map.Entry<E, Count> toRemove;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    this.toRemove = (Map.Entry)iterator.next();
                    return this.toRemove.getKey();
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                    AbstractMapBasedMultiset.this.size -= this.toRemove.getValue().getAndSet(0);
                    iterator.remove();
                    this.toRemove = null;
                }
            };
        }

        @Override
        public boolean remove(Object element) {
            return AbstractMapBasedMultiset.this.removeAllOccurrences(element, this.map) != 0;
        }

        @Override
        public boolean removeAll(Collection<?> elementsToRemove) {
            return Iterators.removeAll(this.iterator(), elementsToRemove);
        }

        @Override
        public boolean retainAll(Collection<?> elementsToRetain) {
            return Iterators.retainAll(this.iterator(), elementsToRetain);
        }

        @Override
        public void clear() {
            if (this.map == AbstractMapBasedMultiset.this.backingMap) {
                AbstractMapBasedMultiset.this.clear();
            } else {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
            }
        }

        public Map<E, Count> getMap() {
            return this.map;
        }
    }

    private class MapBasedMultisetIterator
    implements Iterator<E> {
        final Iterator<Map.Entry<E, Count>> entryIterator;
        Map.Entry<E, Count> currentEntry;
        int occurrencesLeft;
        boolean canRemove;

        MapBasedMultisetIterator() {
            this.entryIterator = AbstractMapBasedMultiset.this.backingMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.occurrencesLeft > 0 || this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            if (this.occurrencesLeft == 0) {
                this.currentEntry = this.entryIterator.next();
                this.occurrencesLeft = this.currentEntry.getValue().get();
            }
            --this.occurrencesLeft;
            this.canRemove = true;
            return this.currentEntry.getKey();
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.canRemove, "no calls to next() since the last call to remove()");
            int n2 = this.currentEntry.getValue().get();
            if (n2 <= 0) {
                throw new ConcurrentModificationException();
            }
            if (this.currentEntry.getValue().addAndGet(-1) == 0) {
                this.entryIterator.remove();
            }
            AbstractMapBasedMultiset.this.size--;
            this.canRemove = false;
        }
    }
}

