/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;

public class DpiUtil {
    private static final String NODE_HORIZONTAL = "HorizontalPixelSize";
    private static final String NODE_VERTICAL = "VerticalPixelSize";
    private static final String NODE_PARENT = "Dimension";
    private static final String NODE_ROOT = "javax_imageio_1.0";
    private static final String NODE_NAME = "value";
    private static final String PNG_EXT = "png";

    private DpiUtil() {
    }

    public static void resetPngDpi(BufferedImage image, int dpi, OutputStream out) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(PNG_EXT);
        while (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(13);
            IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
            if (iIOMetadata.isReadOnly() || !iIOMetadata.isStandardMetadataFormatSupported()) continue;
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(out);
            Throwable throwable = null;
            try {
                DpiUtil.setDPI(iIOMetadata, dpi);
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(iIOMetadata, new IIOImage(image, null, iIOMetadata), imageWriteParam);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (imageOutputStream == null) continue;
                if (throwable != null) {
                    try {
                        imageOutputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                imageOutputStream.close();
            }
        }
    }

    private static void setDPI(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double d2 = 1.0 * (double)dpi / (double)25.4f;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(NODE_HORIZONTAL);
        iIOMetadataNode.setAttribute(NODE_NAME, Double.toString(d2));
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(NODE_VERTICAL);
        iIOMetadataNode2.setAttribute(NODE_NAME, Double.toString(d2));
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode(NODE_PARENT);
        iIOMetadataNode3.appendChild(iIOMetadataNode);
        iIOMetadataNode3.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode(NODE_ROOT);
        iIOMetadataNode4.appendChild(iIOMetadataNode3);
        metadata.mergeTree(NODE_ROOT, iIOMetadataNode4);
    }
}

