/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.httpclient.impl;

import esign.utils.IOUtil;
import esign.utils.asserts.AssertSupport;
import esign.utils.coding.Coder;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfig;
import esign.utils.httpclient.IRequestReady;
import esign.utils.httpclient.IResponseReady;
import esign.utils.httpclient.ProjectAccesser;
import esign.utils.httpclient.ctrl.AccessSignAlg;
import esign.utils.security.cipher.AsymmetricSignerProviderFactory;
import esign.utils.security.cipher.MacSignerProviderFactory;
import esign.utils.security.cipher.impl.ISignerProviderFactory;
import esign.utils.security.cipher.impl.ISimSignerProvider;
import esign.utils.security.model.DigestAlgorithmModel;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSignerConfig
extends HttpConfig
implements IRequestReady,
IResponseReady {
    private static final String HEADER_NAME_TIMEVALE_PROJECT_ID = "X-timevale-project-id";
    private static final String HEADER_NAME_TIMEVALE_MODE = "X-timevale-mode";
    private static final String HEADER_NAME_TIMEVALE_SIGNATURE = "X-timevale-signature";
    private static final String HEADER_NAME_TIMEVALE_SIGNATURE_ALG = "X-timevale-signature-algorithm";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSignerConfig.class);
    private String projectId;
    private AccessSignAlg accessSignAlg;
    private String userSecret;
    private String sysSecret;
    private boolean verify;

    public HttpSignerConfig(ProjectAccesser projectAccesser) {
        this(projectAccesser, true);
    }

    public HttpSignerConfig(ProjectAccesser projectAccesser, boolean verify) {
        this.projectId = projectAccesser.getProjectId();
        this.accessSignAlg = projectAccesser.getAccessSignAlg();
        this.userSecret = projectAccesser.getUserSecret();
        this.sysSecret = projectAccesser.getSystemSecret();
        this.verify = verify;
        this.setRequestReady(this);
        this.setResponseReady(this);
    }

    private static String sign(AccessSignAlg signAlg, String secret, InputStream in) throws SuperException {
        byte[] byArray;
        try {
            byArray = IOUtil.readStreamAsByteArray(in);
        }
        catch (Exception exception) {
            LOGGER.error("read data form stream failed.", (Throwable)exception);
            throw ErrorsDiscriptor.InternalService.e(exception);
        }
        return HttpSignerConfig.sign(byArray, signAlg, secret);
    }

    private static String sign(byte[] stream, AccessSignAlg signAlg, String secret) throws IllegalStateException, SuperException {
        ISimSignerProvider iSimSignerProvider = HttpSignerConfig.signer(signAlg, secret);
        byte[] byArray = iSimSignerProvider.sign(stream);
        return Coder.BINARY.encode(byArray);
    }

    private static boolean verify(byte[] stream, AccessSignAlg signAlg, String secret, byte[] signature) throws IllegalStateException, SuperException {
        ISimSignerProvider iSimSignerProvider = HttpSignerConfig.signer(signAlg, secret);
        return iSimSignerProvider.verify(stream, signature);
    }

    private static ISimSignerProvider signer(AccessSignAlg signAlg, String secret) throws SuperException {
        ISignerProviderFactory iSignerProviderFactory = signAlg.equals((Object)AccessSignAlg.ALG_HMAC_SHA256) ? MacSignerProviderFactory.HMAC.factory(DigestAlgorithmModel.SHA256) : AsymmetricSignerProviderFactory.RSA.factory(DigestAlgorithmModel.SHA1);
        return iSignerProviderFactory.create().init(secret);
    }

    @Override
    public void ready(HttpResponse response, byte[] data) throws SuperException {
        if (!this.verify) {
            return;
        }
        Header header = response.getFirstHeader(HEADER_NAME_TIMEVALE_SIGNATURE);
        AssertSupport.assertNotnull(header, ErrorsDiscriptor.MissingPlatformSignature.e());
        byte[] byArray = Coder.BINARY.decode(header.getValue());
        if (!HttpSignerConfig.verify(data, this.accessSignAlg, this.sysSecret, byArray)) {
            LOGGER.error("verify failed.");
            throw ErrorsDiscriptor.FailureCipherVerify.e();
        }
    }

    @Override
    public void ready(HttpMessage method, HttpEntity entity) throws SuperException {
        method.addHeader(HEADER_NAME_TIMEVALE_PROJECT_ID, this.projectId);
        method.addHeader(HEADER_NAME_TIMEVALE_MODE, "package");
        method.addHeader(HEADER_NAME_TIMEVALE_SIGNATURE_ALG, this.accessSignAlg.disc());
        try {
            method.addHeader(HEADER_NAME_TIMEVALE_SIGNATURE, HttpSignerConfig.sign(this.accessSignAlg, this.userSecret, entity.getContent()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.error("get content failed.", (Throwable)unsupportedOperationException);
            throw ErrorsDiscriptor.InternalService.e(unsupportedOperationException);
        }
        catch (IOException iOException) {
            LOGGER.error("get content failed.", (Throwable)iOException);
            throw ErrorsDiscriptor.InternalService.e(iOException);
        }
    }
}

