package cn.tsign.hz.run;

import cn.tsign.hz.constant.ConfigConstant;
import cn.tsign.hz.core.ClientHelper;
import cn.tsign.hz.core.FileHelper;
import cn.tsign.hz.core.SignHelper;
import cn.tsign.hz.exception.DefineException;
import com.timevale.esign.paas.tech.bean.bean.PosBean;
import com.timevale.esign.paas.tech.bean.request.OrgSignParam;
import com.timevale.esign.paas.tech.bean.request.SignFilePdfParam;
import com.timevale.esign.paas.tech.client.ServiceClient;
import com.timevale.esign.paas.tech.enums.SealSpecEnum;
import com.timevale.esign.paas.tech.enums.SignType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/***
 * description: 企业用户签
 */

public class RunOrgSign {

    private static final Logger LOGGER = LoggerFactory.getLogger(RunOrgSign.class);
    private static SignHelper signHelper;

    static {
        try {
            if (true) {
                //1、注册客户端，全局使用，只需注册一次
                ClientHelper.registClient();
            }

            //2、获取已初始化的客户端，以便后续正常调用SDK提供的各种服务，全局使用，只需获取一次
            ServiceClient serviceClient = ClientHelper.getServiceClient(ConfigConstant.PROJECT_ID);

            //3、实例化辅助类
            signHelper = new SignHelper(serviceClient);
        } catch (DefineException e) {
            e.getE().printStackTrace();
        }
    }

//--------------------------------公有方法 start-------------------------------------

    public static void main(String[] args) throws DefineException {

        switch (0) {
            case 0:
                LOGGER.info("====>场景演示：企业用户PDF文件签署（文件路径方式）<=====");
                orgSignByPdfFile();
                break;
            case 1:
                LOGGER.info("====>场景演示：企业用户PDF文件签署（文件流方式）<=====");
                orgSignByPdfStream();
                break;
            default:
                LOGGER.info("====>请选择应用场景<=====");
                break;
        }
    }
//--------------------------------公有方法 end---------------------------------------

//--------------------------------私有方法 start-------------------------------------

    // 当前程序所在文件目录
    private static final String ROOT_FOLDER = new File("").getAbsolutePath();
    //文件地址前缀拼接（可根据实际场景自定义）
    private static final String PATH_PREFEX = ROOT_FOLDER + File.separator + "pdf" + File.separator;

    /**
     * 文件路径方式企业用户PDF文件签署
     */
    private static void orgSignByPdfFile() throws DefineException {
        /**
         * 企业用户PDF文件路径签署
         */
        // 签署文件信息
        SignFilePdfParam file = new SignFilePdfParam();
        file.setSrcPdfFile(PATH_PREFEX + "test.pdf");// 待签署PDF文件本地路径，含文件名（与bytes至少有一个不为空）
        file.setDstPdfFile(PATH_PREFEX + "Signed_Organize.pdf");// 签署后PDF文件本地路径，含文件名（为空时返回签署后的文件流）
        file.setFileName("我的企业签署文件.pdf");

        // 签章位置信息
        List<PosBean> posBeans = new ArrayList<>();
        PosBean signPos = new PosBean();
        signPos.setPosPage("1");// 签署页码（除关键字签章外，页码均不可为空）若为多页签章，支持指定多个页码，例如格式：“1-3,5,8“
        signPos.setPosX(150);// 签署位置X坐标，若为关键字定位，相对于关键字的X坐标偏移量，默认0
        signPos.setPosY(0);// 签署位置Y坐标，若为关键字定位，相对于关键字的Y坐标偏移量，默认0
        signPos.setKeyWord("甲方盖章");// 关键字，仅限关键字签章时有效，若为关键字定位时，不可空
        signPos.setWidth(159);// 印章展现宽度，将以此宽度对印章图片做同比缩放。
        signPos.setAddSignTime(true);// 是否显示本地签署时间，需要width设置92以上才可以看到时间
        posBeans.add(signPos);

        //企业用户印章Base64数据，需要和企业账号对应的企业名字一致
        String sealData = "MIINhDCCCgUwDhYCRVMCAQQWBWVzaWduFiNlc18wM0I3QzMwQTFBRTM0OTdBOTlDMjE1MkVGNEY3N0MxNTCCAkQCAQEMDOa1i+ivleW8oOi0ugIBATCCAe0EggHpMIIB5TCCAYigAwIBAgIMTdQAAAE7OKSy/YZbMAwGCCqBHM9VAYN1BQAwHzELMAkGA1UEBhMCQ04xEDAOBgNVBAMMB0FIQ0FTTTIwHhcNMjQwNjI1MTAzMDM0WhcNMjUwNjI1MTAzMDM0WjBBMQswCQYDVQQGEwJDTjEVMBMGA1UEAwwM5rWL6K+V5byg6LS6MRswGQYDVQQKDBIxMTAxMDYxOTkwMDEwMTY4OVgwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAASoeLEPuBikR51hqE4vVUuHdnZj0GovHuEWykWKbTu2RaZQ4CZgCuAHK8TymwIs+l1iq2SC3dDy2FlRGHP8OCdAo4GFMIGCMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDBDAOBgNVHQ8BAf8EBAMCAMAwEQYJYIZIAYb4QgEBBAQDAgCAMB8GA1UdIwQYMBaAFARBIXbKJ+ykc9NrRVOjmKcpb0s4MB0GA1UdDgQWBBRuLq/x84V3Y6l91UK1uzUSA6xSTTAMBggqgRzPVQGDdQUAA0kAMEYCIQDmevpn3QekxgTgJovsRc8sDWfPQxxF9y+tCPnc6bII9AIhAOY0Qlui8h+7rtDBnbIJCwIKKi6AnU0YBW5OPuS09MZ5GBMyMDI0MDYyNTE4MzI0MSswODAwGBMyMDI0MDYyNTE4MzI0MSswODAwGBMyMDI1MDYyNTE4MzAzNCswODAwMIIHhBYDUE5HBIIHdYlQTkcNChoKAAAADUlIRFIAAAE7AAAAnggDAAAAeqRdHAAAAA9QTFRF/////wAAAAD/AAAALQNzJ6D3UwAAAAF0Uk5TAEDm2GYAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAb/SURBVHja7V3tlqUoDPRQvv8b1+mdPTO941WRfAL2kn/dVzGpVEJAwG1bsmTJkiVLlixZsmTJkiVLlgwQjHpwWdj/r7HDS7HDcKvxXt5hArO97QAjsINTcbw57J3YcRsOHoe5YPWzdh+W1OcKEgnGxZy3hRKhA4wqsX9+7xezmDRa5iBe2UYS77++GsNAd7RXnlpAO1DYDD6ksTW4ZfqwQ0L9IEtdiH2Sgch0xuylVkIAi5q30FqiYWzJXVQlh1otyi3RNIwpxiPFbGt4qhFC/K+EVTqdxxXhUUs5206wJXZREGSr0mAAnOowgHj4Ix0HZ5D4ojw0wLAcA9dl7BAallaL7Dq71ynsaw1GhyY6fhsOcb1Wqm18hEyv1AwJSCQZyTIYK59mX3FPOISHEWXg/cENlpQV7dNiigRYgsEfVp98yyY/LgnrZMOu0f0YyH2rKnZ6Ho7G3XS2bMQs+/mcYr4zMD3Yb6Wed3eKy4nAMQMoxsJ202SRZJk+RRQjw04zWpHqcv7n3oEoI4hHD8l4+fP2ht2ORnj6ZtwyAfYIhFK5iZNGZLIyKi13j4sZTCgd8RhKO+oBLJNRiYrAdDRyQcpSwe8zlRVZ4+Ek7/dZU8GuTKbomu9qH/JbLNjhLZyC3AH0P7oIWkY/5vFJ/9kSSdneQ7xI2vXDLvrVc07UmqBz4L3W39n9XLbtRVGLiSLWN66IAoSqsQoSvYEY7A5G5Iz8TaCgDrODdozmHc7vZ9kFNutjYiMWOuyuSvfKcTD6KMCbrvXQu6IVq6rImXhmFO2IpzkZUcxeTGTMeiMoVQJ1sEUUkcfsLtZrFyvt1wybEZSEMvvMVhjWT+5Hkh3AC64EGAQJ00BtqchWP5vRl6KWA1KYZE14dds5uja+KsZoetMTsvf5Xjwmy10u+6FmxiID+m+GsrWYvSnSXpbb6V350HA9+JMWjUod/Ai7aptZtqloZ2xvTxxw36x4ZGdiUZxGDBbvl1oYXeYpe4/0bH2vLt8FWX2O1e55Dc3Fn7jNc5pcvE/o8jmez2bJWyYoUhF502lluXxbjN74FN79zRXsSkLYrm10KZTlOx4app/viUurL29raxt/0Mx2OBafN9dB0VeETfDEI0c95ZinX9J4lsjfw+JZDIW7uKyVJbWo3dVVzSDOIfzZFPwLA3g3Sih3BOV3V4g3GjsD0eEm+xU6WDao7Xe29Fn+j8jdnd5kYzkDp7qfLLlO/l1RwGchbYoiyLwhMYs4NlNWxj4OKGCJmjvs+i6dAF1w0xi0MUbufaHSDntSshvlv6trFHQLVQabbp975Iy8q7GFpnsfJj7672sYvu6T2ezojx3TcDK+X/zoVAcfBKXgHYbxbEDLitNM9nkDdPKITXvXMwz3nid1v2iPAGfj5RzYTUZ1ZGKH7rE40A1UYscJ2dDRDXhRzL5TSh3zh5MHuYB75t1LAeq327coWuNUBnO4u0tbOyQrybeytvwQm0ODlrKmigaWoMBFXgMcGrPC+cnV0wpitgYS50UPU2DHYLbV33ZNuw7G31d8vwzgD49V1VbSBna/sPq9+L3nxJj7+HEM5B1z/ZpqJ/shLd8TlfM1IXwv6YELI3by9C12aC8IR4Am/k/D5Aet4WwZ+aLm5MyM3kF7fjQga6r8vam9BA2htIP1fASkdxOquc8B88THRRLh36P0LoqCLmYbd3jRPdMu8CzdMNpd8hNF2LESRqd/jP6cWtt4+GNI2kDpZOfdOlUyZVhm9qD2XK2ihAY25dCBdHHT7Ty6W7KPka0qwluonNzrO+f/6WRsf8cnM7XL98k+v/5za3wraCFQAAFQnXnyNPmR/X4WFV/qv/QB0aOMB+CZjm8pjwp/qnN89wMTgI2KHZGEN+3doKYR8R7QgAABHh4hOI4JUtsjeiHBAe9FAxo/CylzX8sn++FNDjbvXmjXBq/YM4hyiUXrcjfxtqwv5YmwkxGPlhGa8OwMwenPD5Mv1NUYQprAwjs4Lb1Hz/rNkuAJF4GpbDRTjPopPUtpHoft54qb4QO5Ad7DNwVRKWGvkwdqAE1jcMtwwTkX9QxeSZ/Y+Gg981RdPtdFrqpa+C1LaYM0uNSX0mjiUPuLyRB0/lBhd99gz09K6lBkysOoGFe0l0/R2rFEXhg48WSfwN61PNZtldZuzHy+/ulXGr3Qgu7hmfuYoJxFBKSjtjaWzecIT8G29Codxlyb94VTxDr3jFGk+Bo4dJBBp9zXgzhDOe26bkhZRw123b9844DHOmP3jZzDzJLuYY7kVutRrhP4S4V2HGgnqel77Ivv6czoZQCxgpvkloycpir/KnJ9fl371TUd3jzQpILulq8v8bjiXQXya8t5/PgHLlmyZMmSJUuWLFmyZMmSJUuWLFkyTP4BmT04nm3WA/gAAAAASUVORK5CYIICARkCARkEggMiMIIDHjCCAsKgAwIBAgIMN4fVHNBUhw5jCztbMAwGCCqBHM9VAYN1BQAwNzEZMBcGA1UEAwwQVEVTVCBaSENBIFNNMiBDQTENMAsGA1UECgwEWkhDQTELMAkGA1UEBhMCQ04wHhcNMjQwNjE3MDE0NDUyWhcNMjUwNjE3MDE0NDUyWjA8MS0wKwYDVQQDDCTmna3lt57lpKnosLfkv6Hmga/np5HmioDmnInpmZDlhazlj7gxCzAJBgNVBAYTAkNOMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEoSTUdqByjKXzPkrlgY8yY1rqABIgdx/z2GPKuTMJcyRXXNgqMC7cQxRrYUzEnj7DLW6JxslQTecTDidtJPDlRaOCAaswggGnMB8GA1UdIwQYMBaAFJR5Q22ZaA/FWsypkn58HUCZKRdaMFcGA1UdIARQME4wTAYEVR0gADBEMEIGCCsGAQUFBwIBFjZodHRwczovL3d3dy50anpoY2EuY29tL0hvbWUvU3VwcG9ydFNlcnZpY2VzP3N0YXRlPXRhYjcwgZgGCCsGAQUFBwEBBIGLMIGIMEIGCCsGAQUFBzABhjZodHRwczovL3d3dy50anpoY2EuY29tL0hvbWUvU3VwcG9ydFNlcnZpY2VzP3N0YXRlPXRhYjMwQgYIKwYBBQUHMAKGNmh0dHBzOi8vd3d3LnRqemhjYS5jb20vSG9tZS9TdXBwb3J0U2VydmljZXM/c3RhdGU9dGFiMzA3BgNVHR8EMDAuMCygKqAohiZodHRwOi8veGtleS50anpoY2EuY29tOjEwMDIxLzIvMTY5LmNybDAJBgNVHRMEAjAAMCAGCCqBHNAUBAEEBBQTEjkxMzMwMTA4NzQ1ODMwNjA3NzAdBgNVHQ4EFgQUeFbiI7dqJl2wXleYE7ymfK69uV8wCwYDVR0PBAQDAgbAMAwGCCqBHM9VAYN1BQADSAAwRQIgdkNZqt/RKFamVcWS8538qv94LzZOAS/G6PtwdpVhMx4CIQCrsgpIOBSxMaTap1NkkH9eqI9RiXAM3vS8+PgDO7m99wYIKoEcz1UBg3UDSQAwRgIhAOwAW4YncwLjvwMwFzJMFQpKg25SJSb6hmtIkv7j+WfBAiEA3rVRgAd3iSngUbFoE2R71ZEh9GurvtftD0/oJ8UDG2E=";

        //传入企业用户签署参数内
        OrgSignParam orgSignParam = new OrgSignParam();
        /**！！！注意这里企业如果是授权给平台的，只需要传企业账号：accountId即可签署*/
        /**！！！注意这里企业如果是授权给经办人的，那么即需要传企业账号：accountId，还需要传经办人账号：willingnessAccountId和经办人个人认证流程：willingnessId*/
        orgSignParam.setAccountId("9987EED*****20DB2A649710C");//企业账号ID（创建企业签署账号接口返回），需要提前授权给平台
       // orgSignParam.setWillingnessAccountId("37655E43BDB347829A9C20C4559B689E");//经办人个人账号ID（创建个人签署账号接口返回）
       // orgSignParam.setWillingnessId("3426414648315353119");//经办人个人认证流程ID（通过身份核验认证服务-个人认证模块选择任意一种方式认证完成）
        orgSignParam.setSealData(sealData);//印章Base64
        orgSignParam.setPosBeans(posBeans);//签章位置信息
        orgSignParam.setSignType(SignType.Key);//签章类型：Single，单页签章； Multi，多页签章； Edges，签骑缝章； Key，关键字签章
        orgSignParam.setFileBean(file);//签署文件信息
        orgSignParam.setSealSpec(SealSpecEnum.GB_SEAL);//印章规格，默认:：IMAGE；IMAGE-图片base64，GB_SEAL-国标印章
        signHelper.orgSign(orgSignParam);

    }


    /**
     * 文件流方式企业用户PDF文件签署
     */
    private static void orgSignByPdfStream() throws DefineException {

        /**
         * 企业用户PDF文件流签署
         */
        // 签署文件信息
        SignFilePdfParam file = new SignFilePdfParam();
        //PDF文件信息
        String srcPdfPath = PATH_PREFEX + "test.pdf";
        //获取PDF文件的字节流
        byte[] srcPdfBytes = FileHelper.getFileBytes(srcPdfPath);
        file.setStreamFile(srcPdfBytes);// 待填充PDF文件本地二进制数据
        //file.setDstPdfFile(PATH_PREFEX + "Signed_Platform.pdf");// 签署后PDF文件本地路径，含文件名（为空时返回签署后的文件流）
        file.setFileName("我的企业签署文件.pdf");

        // 签章位置信息
        List<PosBean> posBeans = new ArrayList<>();
        PosBean signPos = new PosBean();
        signPos.setPosPage("1");// 签署页码（除关键字签章外，页码均不可为空）若为多页签章，支持指定多个页码，例如格式：“1-3,5,8“
        signPos.setPosX(150);// 签署位置X坐标，若为关键字定位，相对于关键字的X坐标偏移量，默认0
        signPos.setPosY(0);// 签署位置Y坐标，若为关键字定位，相对于关键字的Y坐标偏移量，默认0
        signPos.setKeyWord("甲方盖章");// 关键字，仅限关键字签章时有效，若为关键字定位时，不可空
        signPos.setWidth(159);// 印章展现宽度，将以此宽度对印章图片做同比缩放。
        signPos.setAddSignTime(true);// 是否显示本地签署时间，需要width设置92以上才可以看到时间
        posBeans.add(signPos);

        //印章数据二选一传入
        //企业用户的电子印章结构数据，需要和企业账号对应的企业名字一致
        String sealData = "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";

        //传入企业用户签署参数内
        OrgSignParam orgSignParam = new OrgSignParam();
        /**！！！注意这里企业如果是授权给平台的，只需要传企业账号：accountId即可签署*/
        /**！！！注意这里企业如果是授权给经办人的，那么即需要传企业账号：accountId，还需要传经办人账号：willingnessAccountId和经办人个人认证流程：willingnessId*/
        orgSignParam.setAccountId("9987EE****0DB2A649710C");//企业账号ID（创建企业签署账号接口返回），需要提前授权给平台
        orgSignParam.setWillingnessAccountId("");//经办人个人账号ID（创建个人签署账号接口返回）
        orgSignParam.setWillingnessId("");//经办人个人认证流程ID（通过身份核验认证服务-个人认证模块选择任意一种方式认证完成）
        orgSignParam.setSealData(sealData);//印章Base64
        orgSignParam.setPosBeans(posBeans);//签章位置信息
        orgSignParam.setSignType(SignType.Key);//签章类型：Single，单页签章； Multi，多页签章； Edges，签骑缝章； Key，关键字签章
        orgSignParam.setFileBean(file);//签署文件信息
        orgSignParam.setSealSpec(SealSpecEnum.GB_SEAL);//印章规格，默认:：IMAGE；IMAGE-图片base64，GB_SEAL-国标印章
        signHelper.orgSign(orgSignParam);


    }

//--------------------------------私有方法 end---------------------------------------
}

