package cn.tsign.hz.run;

import cn.tsign.hz.constant.ConfigConstant;
import cn.tsign.hz.core.AuthHelper;
import cn.tsign.hz.core.ClientHelper;
import cn.tsign.hz.core.FileHelper;
import cn.tsign.hz.exception.DefineException;
//import com.timevale.esign.paas.tech.bean.request.OfflineCreateAuthParam;
import com.timevale.esign.paas.tech.bean.request.OfflineCreateAuthParam;
import com.timevale.esign.paas.tech.bean.request.OnlineCreateAuthParam;
//import com.timevale.esign.paas.tech.bean.request.UploadAuthFileParam;
import com.timevale.esign.paas.tech.bean.request.UploadAuthFileParam;
import com.timevale.esign.paas.tech.client.ServiceClient;
import com.timevale.esign.paas.tech.bean.request.AuthFlowSignUrlParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;


/***
 * description: 企业签署授权服务
 */


public class TestAuth {

    private static final Logger LOGGER = LoggerFactory.getLogger(TestAuth.class);
    private static AuthHelper authHelper;

    static {
        try {
            if (true) {
                //1、注册客户端，全局使用，只需注册一次
                ClientHelper.registClient();
            }

            //2、获取已初始化的客户端，以便后续正常调用SDK提供的各种服务，全局使用，只需获取一次
            ServiceClient serviceClient = ClientHelper.getServiceClient(ConfigConstant.PROJECT_ID);

            //3、实例化辅助类
            authHelper = new AuthHelper(serviceClient);
        } catch (DefineException e) {
            e.getE().printStackTrace();
        }
    }

    public static void main(String[] args) throws DefineException {


        switch (0) {
            case 0:
                LOGGER.info("====>场景演示：【线上】发起企业授权书签署任务<=====");
                createAuth();
                break;
            case 1:
                LOGGER.info("====>场景演示：【线上】获取授权签署任务链接<=====");
                getAuthFlowUrl();
                break;
            case 2:
                LOGGER.info("====>场景演示：【线下】发起企业授权书签署任务<=====");
                createAuthOffline();
                break;
            case 3:
                LOGGER.info("====>场景演示：【线下】上传已盖章授权书文件<=====");
                uploadAuthFile();
                break;
            case 4:
                LOGGER.info("====>场景演示：查询授权结果<=====");
                queryAuth();
                break;
            case 5:
                LOGGER.info("====>场景演示：取消授权<=====");
                cancelAuth();
                break;
            default:
                LOGGER.info("====>请选择应用场景<=====");
                break;

        }
    }

    /**
     * 【线上】发起企业授权书签署任务
     */
    private static String createAuth() throws DefineException {
        OnlineCreateAuthParam onlineCreateAuthParam = new OnlineCreateAuthParam();//创建授权参数
        onlineCreateAuthParam.setOrganizeId("9987EED00*****649710C");//授权方企业账号ID
        //onlineCreateAuthParam.setPersonId("1FE511CE9****506C0C02FBDA22D");//授权方经办人个人账号ID
        onlineCreateAuthParam.setAuthType(1);//授权模式，默认为 1（授权至平台）：1 - 授权至平台，personId无需传递；2 - 授权至经办人，personId必传
        onlineCreateAuthParam.setContact("153****650");//手机号或者邮箱
        onlineCreateAuthParam.setSendNotice(true);//是否发送通知
        onlineCreateAuthParam.setSealScope("合同专用章");//自定义授权印章范围
        onlineCreateAuthParam.setFileType("物流条款");//自定义签署文件类型
        onlineCreateAuthParam.setNotifyUrl("http://81.68.86.172:58081/CSTNotify/asyn/notify?belong=jilin");//回调通知地址
        onlineCreateAuthParam.setRedirectUrl("wechat://back");//重定向跳转地址
        onlineCreateAuthParam.setValidDate(17085374740000L);//授权有效期截止时间（截止到当日0点）
        return authHelper.createAuth(onlineCreateAuthParam);

    }


    /**
     * 【线上】获取授权签署任务链接
     */
    private static String getAuthFlowUrl() throws DefineException {
        AuthFlowSignUrlParam authFlowSignUrlParam = new AuthFlowSignUrlParam();
        authFlowSignUrlParam.setAuthId("343315*****55870");//授权流程ID
        authFlowSignUrlParam.setNeedLogin(false);//是否需要登录打开链接:true - 需登录打开链接，false - 免登录
        authFlowSignUrlParam.setRedirectUrl("");//重定向跳转地址
        authFlowSignUrlParam.setClientType("ALL");//指定客户端类型，默认值 ：ALL ; H5 - 移动端适配 , PC - PC端适配 , ALL - 自动适配移动端或PC端
        return authHelper.getAuthFlowUrl(authFlowSignUrlParam);
    }

    /**
     * 【线下】发起企业授权书签署任务
     */
    private static String createAuthOffline() throws DefineException {
        OfflineCreateAuthParam offlineCreateAuthParam = new OfflineCreateAuthParam();//创建授权参数
        offlineCreateAuthParam.setOrganizeId("C1CF3A85*****879697564B05C0");//授权方企业账号ID
        //offlineCreateAuthParam.setPersonId("37655E43*****20C4559B689E");//授权方经办人个人账号ID
        offlineCreateAuthParam.setAuthType(1);//授权模式，默认为 1（授权至平台）：1 - 授权至平台，personId无需传递；2 - 授权至经办人，personId必传
        offlineCreateAuthParam.setSealScope("合同专用章");//自定义授权印章范围
        offlineCreateAuthParam.setFileType("物流条款");//自定义签署文件类型
        offlineCreateAuthParam.setNotifyUrl("http://81.68.86.172:58081/CSTNotify/asyn/notify?belong=jilin");//回调通知地址
        offlineCreateAuthParam.setValidDate(17085374740000L);//授权有效期截止时间（截止到当日0点）
        return authHelper.createAuthOffline(offlineCreateAuthParam);

    }


    /**
     * 【线下】上传已盖章授权书文件
     */

    // 当前程序所在文件目录
    private static final String ROOT_FOLDER = new File("").getAbsolutePath();
    //文件地址前缀拼接（可根据实际场景自定义）
    private static final String PATH_PREFEX = ROOT_FOLDER + File.separator + "pdf" + File.separator;

    private static void uploadAuthFile() throws DefineException {
        UploadAuthFileParam uploadAuthFileParam = new UploadAuthFileParam();
        uploadAuthFileParam.setAuthId("3426199791183859401");//授权流程ID
        //uploadAuthFileParam.setFileName("名字");//文件名称
        //PDF文件信息
        String srcPdfPath = PATH_PREFEX + "授权.pdf";
        uploadAuthFileParam.setSrcPdfFile(srcPdfPath);//盖章后待审核PDF文件本地路径
        // 获取PDF文件的字节流
        byte[] srcPdfBytes = FileHelper.getFileBytes(srcPdfPath);
        uploadAuthFileParam.setStreamFile(srcPdfBytes);// 盖章后待审核PDF文件本地二进制数据*/
        authHelper.uploadAuthFile(uploadAuthFileParam);
    }


    /**
     * 查询授权结果
     */
    private static int queryAuth() throws DefineException {
        String authId = "34261****3859401";
        return authHelper.queryAuth(authId);//授权状态，1-进行中 2-授权成功 3-授权失败 4-取消授权
    }

    /**
     * 取消授权
     */
    private static void cancelAuth() throws DefineException {
        String authId = "17519****25122050";
        authHelper.cancelAuth(authId);
    }
}

