package cn.tsign.hz.run;

import cn.tsign.hz.core.ClientHelper;
import cn.tsign.hz.exception.DefineException;
import com.timevale.esign.paas.tech.bean.request.GbOfficialSealParam;
import com.timevale.esign.paas.tech.bean.request.GbPersonalSealParam;
import com.timevale.esign.paas.tech.bean.result.AddGbSealResult;
import com.timevale.esign.paas.tech.bean.result.ParseSealResult;
import com.timevale.esign.paas.tech.client.ServiceClient;
import com.timevale.esign.paas.tech.client.ServiceClientManager;
import com.timevale.esign.paas.tech.enums.OrganizeTemplateType;
import com.timevale.esign.paas.tech.enums.PersonTemplateType;
import com.timevale.esign.paas.tech.enums.SealColor;
import com.timevale.esign.paas.tech.enums.StampRuleEnum;
import com.timevale.esign.paas.tech.service.TemplateSealService;
import net.sf.json.JSONObject;
import java.util.Arrays;
import static com.sun.xml.internal.ws.spi.db.BindingContextFactory.LOGGER;


public class TestGbSeal {

    public static void main(String[] args) throws DefineException {

        ClientHelper.registClient();
        // 获取客户端的代码：
        ServiceClient serviceClient = ServiceClientManager.get("4439024678");
        TemplateSealService templateSealService = serviceClient.templateSealService();

        /** 印章服务
         * 1.个人电子印章制章 + 电子印章数据解析
         * */

        LOGGER.info("====>场景演示：1.1 个人电子印章制章<=====");
        GbPersonalSealParam psnSealInfo = new GbPersonalSealParam();
        psnSealInfo.setAccountId("03B7C30*****152EF4F77C15");//个人账号ID，用来获取绘制印章的名称以及获取证书信息
        psnSealInfo.setSealImage("");//印章图片base64数据，传了此参数将不再读取下方所有参数。若都传，以此参数为准
        psnSealInfo.setType(PersonTemplateType.BORDERLESS);//印章模板类型：可选：SQUARE-正方形印章 | RECTANGLE-矩形印章 | BORDERLESS-无框矩形印章
        psnSealInfo.setColor(SealColor.BLACK);//个人印章颜色：RED-红色 | BLUE-蓝色 | BLACK-黑色
        psnSealInfo.setStampRule(StampRuleEnum.SEAL_NONE);//印章是否加“印”规则：SEAL_NONE，无‘印’|  SEAL_ONE，带‘印’|  SEAL_TWO，带‘之印’
        AddGbSealResult addGbSealResult = templateSealService.createGbPersonalSeal(psnSealInfo);

        if (addGbSealResult.getErrCode() != 0)
            System.out.println("个人电子印章制章失败：" + JSONObject.fromObject(addGbSealResult));
        else {
            System.out.println("个人电子印章制章成功," + JSONObject.fromObject(addGbSealResult));

            LOGGER.info("====>场景演示：1.2 个人电子印章数据解析<=====");
            ParseSealResult parseSealResult = templateSealService.sealInfoParse(addGbSealResult.getSealData());
            if (parseSealResult.getErrCode() != 0)
                System.out.println("个人电子印章数据解析失败：" + JSONObject.fromObject(parseSealResult));
            else
                System.out.println("个人电子印章数据解析成功," + JSONObject.fromObject(parseSealResult));
        }


        /** 印章服务
         * 2.企业电子印章制章 + 电子印章数据解析
         * */
        LOGGER.info("====>场景演示：2.1 企业电子印章制章<=====");
        GbOfficialSealParam orgSealInfo = new GbOfficialSealParam();
        orgSealInfo.setAccountId("15B0E87C*****754A35CB7BB");//企业账号ID，用来获取绘制印章的名称以及获取证书信息
        orgSealInfo.setSealImage("");//印章图片base64数据，传了此参数将不再读取下方所有参数。若都传，以此参数为准
        orgSealInfo.setType(OrganizeTemplateType.STAR);// 印章模板类型,可选：STAR-标准公章 | DEDICATED-圆形无五角星章 | OVAL-椭圆形印章
        orgSealInfo.setColor(SealColor.RED);//印章颜色：RED-红色 | BLUE-蓝色 | BLACK-黑色
        orgSealInfo.sethTexts(Arrays.asList("合同专用章"));//生成印章中的横向文内容 如“合同专用章、财务专用章”
        orgSealInfo.setqText("");//生成印章中的下弦文内容，公章防伪码（一般为13位数字），没有可以传空
        AddGbSealResult addGbSealResult2 = templateSealService.createGbOfficialSeal(orgSealInfo);

        if (addGbSealResult2.getErrCode() != 0)
            System.out.println("企业电子印章制章失败：" + JSONObject.fromObject(addGbSealResult2));
        else {
            System.out.println("企业电子印章制章成功," + JSONObject.fromObject(addGbSealResult2));

            LOGGER.info("====>场景演示：2.2 企业电子印章数据解析<=====");
            ParseSealResult parseSealResult2 = templateSealService.sealInfoParse(addGbSealResult2.getSealData());
            if (parseSealResult2.getErrCode() != 0)
                System.out.println("企业电子印章数据解析失败：" + JSONObject.fromObject(parseSealResult2));
            else
                System.out.println("企业电子印章数据解析成功," + JSONObject.fromObject(parseSealResult2));
        }
    }

}
