package run;

import cn.tign.hz.bean.OrgEntity;
import cn.tign.hz.comm.DeclareDetails;
import cn.tign.hz.factory.Factory;
import cn.tign.hz.factory.base.OrgIdentityVerify;
import cn.tign.hz.factory.orgIdentity.*;
import cn.tign.hz.factory.response.orgIdentity.OrgFourFactorsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 实名认证企业实名认证API版示例
 * @author  澄泓
 * @date  2020/11/17 16:05
 * @version JDK1.7
 */
public class OrgApiVerifyDemo {
    static{
        DeclareDetails.showImportantMessage();//demo声明明细
//        正式环境域名：https://openapi.esign.cn
//        模拟环境（沙箱环境）域名：https://smlopenapi.esign.cn
        String host="https://smlopenapi.esign.cn"; //网关
        String project_id="";//应用id
        String project_scert="";//密钥
        Factory.init(host,project_id,project_scert);//初始化，传入请求网关和应用id以及密钥,全局运行一次
        Factory.setDebug(true);//开启日志，测试阶段建议开启，方便记录数据，日志保存在根目录的log.txt文件中
    }
    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(OrgApiVerifyDemo.class);
        try{
            //创建签署账号接口生成的企业账号
            String accountId="";
            String agentAccountId="";
            String name="";//name参数，机构名称
            String orgCode="";//idNumber参数,机构证件号
            String legalRepName="";//法人姓名
            String legalRepIdNo="";//法人身份证号
            String mobileNo="";//手机号

            logger.info("-----------------发起企业实名认证4要素校验 start-----------------");
            OrgFourFactorsByAccount orgFourFactorsByAccount = OrgIdentityVerify.orgFourFactorsByAccount(accountId, agentAccountId);
            OrgFourFactorsResponse orgFourFactorsByAccountResponse = orgFourFactorsByAccount.execute();
            String flowId = orgFourFactorsByAccountResponse.getData().getFlowId();
            logger.info("-----------------发起企业实名认证4要素校验 end-----------------");

//            logger.info("-----------------发起企业核身认证4要素校验 start-----------------");
//            OrgFourFactors orgFourFactors = OrgIdentityVerify.orgFourFactors(name, orgCode, legalRepName, legalRepIdNo);
//            orgFourFactors.execute();
//            logger.info("-----------------发起企业核身认证4要素校验 end-----------------");

//            logger.info("-----------------发起企业实名认证3要素校验 start-----------------");
//            OrgThreeFactorsByAccount orgThreeFactorsByAccount = OrgIdentityVerify.orgThreeFactorsByAccount(accountId, agentAccountId);
//            orgThreeFactorsByAccount.execute();
//            logger.info("-----------------发起企业实名认证3要素校验 end-----------------");

//            logger.info("-----------------发起企业核身认证3要素检验 start-----------------");
//            OrgThreeFactors orgThreeFactors = OrgIdentityVerify.orgThreeFactors(name, orgCode, legalRepName);
//            orgThreeFactors.execute();
//            logger.info("-----------------发起企业核身认证3要素检验 end-----------------");

            //授权签署认证 发起随机金额打款认证 企业反向打款认证三个选择其中一种认证方式即可
            //这里以授权书签署为例
            logger.info("-----------------发起授权签署实名认证 start-----------------");
            OrglegalRepSignAuth orglegalRepSignAuth = OrgIdentityVerify.orglegalRepSignAuth(flowId, mobileNo);
            orglegalRepSignAuth.setLegalRepIdNo(legalRepIdNo);
            orglegalRepSignAuth.execute();
            logger.info("-----------------发起授权签署实名认证 end-----------------");


        }catch (Exception e){
            e.printStackTrace();
        }
        System.out.println("运行结束");
    }
}
