package run;

import cn.tign.hz.bean.OrgEntity;
import cn.tign.hz.comm.DeclareDetails;
import cn.tign.hz.factory.Factory;
import cn.tign.hz.factory.base.OrgIdentityVerify;
import cn.tign.hz.factory.base.PsnIdentityVerify;
import cn.tign.hz.factory.indivIdentity.IndivAuthUrl;
import cn.tign.hz.factory.indivIdentity.IndivIdentityUrl;
import cn.tign.hz.factory.orgIdentity.OrgAuthUrl;
import cn.tign.hz.factory.orgIdentity.OrgIdentityUrl;
import cn.tign.hz.factory.response.indivIdentity.IndivAuthUrlResponse;
import cn.tign.hz.factory.response.indivIdentity.IndivIdentityUrlResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 实名认证企业认证网页版示例
 * @author  澄泓
 * @date  2020/11/17 15:03
 * @version JDK1.7
 */
public class OrgWebVerifyDemo {
    static{
        DeclareDetails.showImportantMessage();//demo声明明细
//        正式环境域名：https://openapi.esign.cn
//        模拟环境（沙箱环境）域名：https://smlopenapi.esign.cn
        String host="https://smlopenapi.esign.cn"; //网关
        String project_id="";//应用id
        String project_scert="";//密钥
        Factory.init(host,project_id,project_scert);//初始化，传入请求网关和应用id以及密钥,全局运行一次
        Factory.setDebug(true);//开启日志，测试阶段建议开启，方便记录数据，日志保存在根目录的log.txt文件中
    }
    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(OrgWebVerifyDemo.class);
        try{
            String accountId="";//机构账号
            String agentAccountId="";//个人账号
            String name="";//name参数，机构名称
            String orgCode="";//idNumber参数,机构证件号
            logger.info("-----------------获取组织机构实名认证地址 start-----------------");
            OrgIdentityUrl orgIdentityUrl = OrgIdentityVerify.orgIdentityUrl(accountId, agentAccountId);
            orgIdentityUrl.execute();
            logger.info("-----------------获取组织机构实名认证地址 end-----------------");


            logger.info("-----------------获取组织机构核身地址 start-----------------");
            OrgAuthUrl orgAuthUrl = OrgIdentityVerify.orgAuthUrl();
            OrgEntity orgEntity = new OrgEntity();
            orgEntity.setName(name);
            orgEntity.setCertNo(orgCode);
            orgAuthUrl.setOrgEntity(orgEntity);
            orgAuthUrl.execute();
            logger.info("-----------------获取组织机构核身地址 end-----------------");


        }catch (Exception e){
            e.printStackTrace();
        }
        System.out.println("运行结束");
    }

}
