package run;

import cn.tign.hz.comm.DeclareDetails;
import cn.tign.hz.factory.Factory;
import cn.tign.hz.factory.base.PsnIdentityVerify;
import cn.tign.hz.factory.indivIdentity.*;
import cn.tign.hz.factory.response.indivIdentity.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 实名认证个人实名认证API版示例
 * @author  澄泓
 * @date  2020/11/17 10:10
 * @version JDK1.7
 */
public class PsnApiVerifyDemo {
    static{
        DeclareDetails.showImportantMessage();//demo声明明细
//        正式环境域名：https://openapi.esign.cn
//        模拟环境（沙箱环境）域名：https://smlopenapi.esign.cn
        String host="https://smlopenapi.esign.cn"; //网关
        String project_id="";//应用id
        String project_scert="";//密钥
        Factory.init(host,project_id,project_scert);//初始化，传入请求网关和应用id以及密钥,全局运行一次
        Factory.setDebug(true);//开启日志，测试阶段建议开启，方便记录数据，日志保存在根目录的log.txt文件中
    }
    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(PsnApiVerifyDemo.class);
        try{
            //签署账号创建接口生成的account_Id
            String accountId="";//个人账号
            //认证完成以后前端需要跳转的页面地址
            String callbackUrl="https://open.esign.cn";
            String mobileNo="";//手机号
            String name="";//姓名
            String idNo="";//身份证号
            String bankCardNo="";//银行卡号
            logger.info("-----------------发起个人刷脸实名认证 start-----------------");
            FaceIdentityByAccount faceIdentityByAccount = PsnIdentityVerify.faceIdentityByAccount(accountId,"TENCENT",callbackUrl);
            FaceIdentityByAccountResponse faceByActResponse= faceIdentityByAccount.execute();
            String flowId=faceByActResponse.getData().getFlowId();
            logger.info("-----------------发起个人刷脸实名认证 end-----------------");


            logger.info("-----------------查询个人刷脸状态 start-----------------");
            QryFaceStatus qryFaceStatus = PsnIdentityVerify.qryFaceStatus(flowId);
            qryFaceStatus.execute();
            logger.info("-----------------查询个人刷脸状态 end-----------------");


            logger.info("-----------------发起运营商3要素实名认证 start-----------------");
            IndividualTelecom3FactorsByAccount telecom3FactorsByAccount = PsnIdentityVerify.individualTelecom3FactorsByAccount(accountId, mobileNo);
            IndividualTelecom3FactorsResponse telecom3FactorsByAccountResponse = telecom3FactorsByAccount.execute();
            flowId=telecom3FactorsByAccountResponse.getData().getFlowId();
            logger.info("-----------------发起运营商3要素实名认证 end-----------------");

            logger.info("-----------------发起运营商3要素核身认证 start-----------------");
            IndividualTelecom3Factors telecom3Factors = PsnIdentityVerify.individualTelecom3Factors(name, idNo, mobileNo);
            telecom3Factors.execute();
            logger.info("-----------------发起运营商3要素核身认证 end-----------------");

            logger.info("-----------------运营商短信验证码校验 start-----------------");
            String authCode="";//发起运营商三要素以后收到的短信验证码
            Tel3FactorsCodeVerify tel3FactorsCodeVerify = PsnIdentityVerify.tel3FactorsCodeVerify(flowId, authCode);
            tel3FactorsCodeVerify.execute();
            logger.info("-----------------运营商短信验证码校验 end-----------------");

            logger.info("-----------------发起银行4要素实名认证 start-----------------");
            IndividualBankCard4FactorsByAccount bankCard4FactorsByAccount = PsnIdentityVerify.individualBankCard4FactorsByAccount(accountId, mobileNo, bankCardNo);
            IndividualBankCard4FactorsResponse bankResponse = bankCard4FactorsByAccount.execute();
            flowId=bankResponse.getData().getFlowId();
            logger.info("-----------------发起银行4要素实名认证 end-----------------");

            logger.info("-----------------发起银行4要素核身认证 start-----------------");
            IndividualBankCard4Factors bankCard4Factors = PsnIdentityVerify.individualBankCard4Factors(name, "INDIVIDUAL_CH_IDCARD", idNo,mobileNo, bankCardNo);
            bankCard4Factors.execute();
            logger.info("-----------------发起银行4要素核身认证 end-----------------");


            logger.info("-----------------银行预留手机号验证码校验 start-----------------");
            authCode="";//发起银行卡四要素以后手机收到的短信验证码
            PsnIdentityVerify.bankCard4FactorsCodeVerify(flowId,authCode);
            logger.info("-----------------银行预留手机号验证码校验 end-----------------");



        }catch (Exception e){
            e.printStackTrace();
        }
        System.out.println("运行结束");
    }
}
