package run;

import cn.tign.hz.comm.DeclareDetails;
import cn.tign.hz.factory.Factory;
import cn.tign.hz.factory.base.PsnIdentityVerify;
import cn.tign.hz.factory.indivIdentity.IndivAuthUrl;
import cn.tign.hz.factory.indivIdentity.IndivIdentityUrl;
import cn.tign.hz.factory.response.indivIdentity.IndivAuthUrlResponse;
import cn.tign.hz.factory.response.indivIdentity.IndivIdentityUrlResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 实名认证个人实名认证网页版demo
 * @author  澄泓
 * @date  2020/11/17 10:00
 * @version JDK1.7
 */
public class PsnWebVerifyDemo {
    static{
        DeclareDetails.showImportantMessage();//demo声明明细
//        正式环境域名：https://openapi.esign.cn
//        模拟环境（沙箱环境）域名：https://smlopenapi.esign.cn
        String host="https://smlopenapi.esign.cn"; //网关
        String project_id="";//应用id
        String project_scert="";//密钥
        Factory.init(host,project_id,project_scert);//初始化，传入请求网关和应用id以及密钥,全局运行一次
        Factory.setDebug(true);//开启日志，测试阶段建议开启，方便记录数据，日志保存在根目录的log.txt文件中
    }
    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(PsnWebVerifyDemo.class);
        try{
            String accountId="";//个人账号
            logger.info("-----------------获取个人实名认证地址 start-----------------");
            IndivIdentityUrl indivIdentityUrl = PsnIdentityVerify.indivIdentityUrl(accountId);
            indivIdentityUrl.setRepeatIdentity(false);
            IndivIdentityUrlResponse indivIdentityUrlResponse = indivIdentityUrl.execute();
            logger.info("-----------------获取个人实名认证地址 end-----------------");


            logger.info("-----------------获取个人核身认证地址 start-----------------");
            IndivAuthUrl indivAuthUrl = PsnIdentityVerify.indivAuthUrl();
            IndivAuthUrlResponse indivAuthUrlResponse = indivAuthUrl.execute();
            logger.info("-----------------获取个人核身认证地址 end-----------------");

        }catch (Exception e){
            e.printStackTrace();
        }
        System.out.println("运行结束");
    }
}
