<?php

namespace factory\signfile\datasign;
use factory\request\EsignRequest;

/**
 * 轩辕API平台方&平台用户文本签
 * @author  澄泓
 * @date  2020/11/24 14:28
 */
class DataSign extends EsignRequest implements \JsonSerializable
{
    private $accountId;
    private $data;
    private $type;

    /**
     * DataSign constructor.
     * @param $data
     * @param $type
     */
    public function __construct($data, $type)
    {
        $this->data = $data;
        $this->type = $type;
    }

    /**
     * @return mixed
     */
    public function getAccountId()
    {
        return $this->accountId;
    }

    /**
     * @param mixed $accountId
     * @return DataSign
     */
    public function setAccountId($accountId)
    {
        $this->accountId = $accountId;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param mixed $data
     * @return DataSign
     */
    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed $type
     * @return DataSign
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    function build()
    {
        $this->setUrl("/v1/dataSign");
        $this->setReqType(\HttpEmun::POST);
    }

    /**
     * Specify data which should be serialized to JSON
     * @link https://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        $json = array();
        foreach ($this as $key => $value) {
            if($value===null) {
                continue;
            }
            $json[$key] = $value;
        }
        return $json;
    }
}