/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DEROutputStream;
import com.timevale.tgtext.bouncycastle.asn1.DLOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASN1OutputStream {
    private OutputStream os;

    public ASN1OutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    void writeLength(int n2) throws IOException {
        if (n2 > 127) {
            int n3 = 1;
            int n4 = n2;
            while ((n4 >>>= 8) != 0) {
                ++n3;
            }
            this.write((byte)(n3 | 0x80));
            for (int i2 = n3 - 1 << 3; i2 >= 0; i2 -= 8) {
                this.write((byte)(n2 >> i2));
            }
            return;
        }
        this.write((byte)n2);
    }

    void write(int n2) throws IOException {
        this.os.write(n2);
    }

    void write(byte[] byArray) throws IOException {
        this.os.write(byArray);
    }

    void write(byte[] byArray, int n2, int n3) throws IOException {
        this.os.write(byArray, n2, n3);
    }

    void writeEncoded(int n2, byte[] byArray) throws IOException {
        this.write(n2);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    void writeTag(int n2, int n3) throws IOException {
        if (n3 < 31) {
            this.write(n2 | n3);
            return;
        }
        this.write(n2 | 0x1F);
        if (n3 < 128) {
            this.write(n3);
            return;
        }
        byte[] byArray = new byte[5];
        int n4 = 5;
        --n4;
        byArray[4] = (byte)(n3 & 0x7F);
        do {
            byArray[--n4] = (byte)((n3 >>= 7) & 0x7F | 0x80);
        } while (n3 > 127);
        this.write(byArray, n4, 5 - n4);
    }

    void writeEncoded(int n2, int n3, byte[] byArray) throws IOException {
        this.writeTag(n2, n3);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    protected void writeNull() throws IOException {
        this.os.write(5);
        this.os.write(0);
    }

    public void writeObject(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable != null) {
            aSN1Encodable.toASN1Primitive().encode(this);
            return;
        }
        throw new IOException("null object detected");
    }

    void writeImplicitObject(ASN1Primitive aSN1Primitive) throws IOException {
        if (aSN1Primitive != null) {
            aSN1Primitive.encode(new ImplicitOutputStream(this.os));
            return;
        }
        throw new IOException("null object detected");
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    ASN1OutputStream getDERSubStream() {
        return new DEROutputStream(this.os);
    }

    ASN1OutputStream getDLSubStream() {
        return new DLOutputStream(this.os);
    }

    private class ImplicitOutputStream
    extends ASN1OutputStream {
        private boolean first;

        public ImplicitOutputStream(OutputStream outputStream) {
            super(outputStream);
            this.first = true;
        }

        @Override
        public void write(int n2) throws IOException {
            if (this.first) {
                this.first = false;
                return;
            }
            super.write(n2);
        }
    }
}

