/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1SetParser;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.BERSet;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.DLSet;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Iterable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class ASN1Set
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    private Vector set = new Vector();
    private boolean isSorted = false;

    public static ASN1Set getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1Set) {
            return (ASN1Set)object;
        }
        if (object instanceof ASN1SetParser) {
            return ASN1Set.getInstance(((ASN1SetParser)object).toASN1Primitive());
        }
        if (object instanceof byte[]) {
            try {
                return ASN1Set.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct set from byte[]: " + iOException.getMessage());
            }
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1Set) {
            return (ASN1Set)aSN1Primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        if (bl2) {
            if (!aSN1TaggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)aSN1TaggedObject.getObject();
        }
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (aSN1TaggedObject.isExplicit()) {
            if (aSN1TaggedObject instanceof BERTaggedObject) {
                return new BERSet(aSN1Primitive);
            }
            return new DLSet(aSN1Primitive);
        }
        if (aSN1Primitive instanceof ASN1Set) {
            return (ASN1Set)aSN1Primitive;
        }
        if (aSN1Primitive instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
            if (aSN1TaggedObject instanceof BERTaggedObject) {
                return new BERSet(aSN1Sequence.toArray());
            }
            return new DLSet(aSN1Sequence.toArray());
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + aSN1TaggedObject.getClass().getName());
    }

    protected ASN1Set() {
    }

    protected ASN1Set(ASN1Encodable aSN1Encodable) {
        this.set.addElement(aSN1Encodable);
    }

    protected ASN1Set(ASN1EncodableVector aSN1EncodableVector, boolean bl2) {
        for (int i2 = 0; i2 != aSN1EncodableVector.size(); ++i2) {
            this.set.addElement(aSN1EncodableVector.get(i2));
        }
        if (bl2) {
            this.sort();
        }
    }

    protected ASN1Set(ASN1Encodable[] aSN1EncodableArray, boolean bl2) {
        for (int i2 = 0; i2 != aSN1EncodableArray.length; ++i2) {
            this.set.addElement(aSN1EncodableArray[i2]);
        }
        if (bl2) {
            this.sort();
        }
    }

    public Enumeration getObjects() {
        return this.set.elements();
    }

    public ASN1Encodable getObjectAt(int n2) {
        return (ASN1Encodable)this.set.elementAt(n2);
    }

    public int size() {
        return this.set.size();
    }

    public ASN1Encodable[] toArray() {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[this.size()];
        for (int i2 = 0; i2 != this.size(); ++i2) {
            aSN1EncodableArray[i2] = this.getObjectAt(i2);
        }
        return aSN1EncodableArray;
    }

    public ASN1SetParser parser() {
        final ASN1Set aSN1Set = this;
        return new ASN1SetParser(){
            private final int max;
            private int index;
            {
                this.max = ASN1Set.this.size();
            }

            @Override
            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable aSN1Encodable;
                if (this.index == this.max) {
                    return null;
                }
                if ((aSN1Encodable = ASN1Set.this.getObjectAt(this.index++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)aSN1Encodable).parser();
                }
                if (aSN1Encodable instanceof ASN1Set) {
                    return ((ASN1Set)aSN1Encodable).parser();
                }
                return aSN1Encodable;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return aSN1Set;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return aSN1Set;
            }
        };
    }

    @Override
    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n2 = this.size();
        while (enumeration.hasMoreElements()) {
            ASN1Encodable aSN1Encodable = this.getNext(enumeration);
            n2 *= 17;
            n2 ^= aSN1Encodable.hashCode();
        }
        return n2;
    }

    @Override
    ASN1Primitive toDERObject() {
        if (this.isSorted) {
            DERSet dERSet = new DERSet();
            new DERSet().set = this.set;
            return dERSet;
        }
        Vector vector = new Vector();
        for (int i2 = 0; i2 != this.set.size(); ++i2) {
            vector.addElement(this.set.elementAt(i2));
        }
        DERSet dERSet = new DERSet();
        new DERSet().set = vector;
        dERSet.sort();
        return dERSet;
    }

    @Override
    ASN1Primitive toDLObject() {
        DLSet dLSet = new DLSet();
        new DLSet().set = this.set;
        return dLSet;
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Set)) {
            return false;
        }
        ASN1Set aSN1Set = (ASN1Set)aSN1Primitive;
        if (this.size() != aSN1Set.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Primitive aSN1Primitive2;
            ASN1Encodable aSN1Encodable = this.getNext(enumeration);
            ASN1Encodable aSN1Encodable2 = this.getNext(enumeration2);
            ASN1Primitive aSN1Primitive3 = aSN1Encodable.toASN1Primitive();
            if (aSN1Primitive3 == (aSN1Primitive2 = aSN1Encodable2.toASN1Primitive()) || aSN1Primitive3.equals(aSN1Primitive2)) continue;
            return false;
        }
        return true;
    }

    private ASN1Encodable getNext(Enumeration enumeration) {
        ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        if (aSN1Encodable == null) {
            return DERNull.INSTANCE;
        }
        return aSN1Encodable;
    }

    private boolean lessThanOrEqual(byte[] byArray, byte[] byArray2) {
        int n2 = Math.min(byArray.length, byArray2.length);
        for (int i2 = 0; i2 != n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return (byArray[i2] & 0xFF) < (byArray2[i2] & 0xFF);
        }
        return n2 == byArray.length;
    }

    private byte[] getDEREncoded(ASN1Encodable aSN1Encodable) {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
    }

    protected void sort() {
        if (!this.isSorted) {
            this.isSorted = true;
            if (this.set.size() > 1) {
                boolean bl2 = true;
                int n2 = this.set.size() - 1;
                while (bl2) {
                    int n3 = 0;
                    byte[] byArray = this.getDEREncoded((ASN1Encodable)this.set.elementAt(0));
                    bl2 = false;
                    for (int i2 = 0; i2 != n2; ++i2) {
                        byte[] byArray2 = this.getDEREncoded((ASN1Encodable)this.set.elementAt(i2 + 1));
                        if (this.lessThanOrEqual(byArray, byArray2)) {
                            byArray = byArray2;
                            continue;
                        }
                        Object e2 = this.set.elementAt(i2);
                        this.set.setElementAt(this.set.elementAt(i2 + 1), i2);
                        this.set.setElementAt(e2, i2 + 1);
                        bl2 = true;
                        n3 = i2;
                    }
                    n2 = n3;
                }
            }
        }
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return this.set.toString();
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.toArray());
    }
}

