/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Choice;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Exception;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObjectParser;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DLTaggedObject;
import java.io.IOException;

public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    int tagNo;
    boolean empty = false;
    boolean explicit = true;
    ASN1Encodable obj = null;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        if (bl2) {
            return (ASN1TaggedObject)aSN1TaggedObject.getObject();
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public static ASN1TaggedObject getInstance(Object object) {
        if (object == null || object instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)object;
        }
        if (object instanceof byte[]) {
            try {
                return ASN1TaggedObject.getInstance(ASN1TaggedObject.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct tagged object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public ASN1TaggedObject(boolean bl2, int n2, ASN1Encodable aSN1Encodable) {
        this.explicit = aSN1Encodable instanceof ASN1Choice ? true : bl2;
        this.tagNo = n2;
        if (this.explicit) {
            this.obj = aSN1Encodable;
            return;
        }
        aSN1Encodable.toASN1Primitive();
        this.obj = aSN1Encodable;
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
        if (this.tagNo != aSN1TaggedObject.tagNo || this.empty != aSN1TaggedObject.empty || this.explicit != aSN1TaggedObject.explicit) {
            return false;
        }
        return !(this.obj == null ? aSN1TaggedObject.obj != null : !this.obj.toASN1Primitive().equals(aSN1TaggedObject.obj.toASN1Primitive()));
    }

    @Override
    public int hashCode() {
        int n2 = this.tagNo;
        if (this.obj != null) {
            n2 ^= this.obj.hashCode();
        }
        return n2;
    }

    @Override
    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public ASN1Primitive getObject() {
        if (this.obj != null) {
            return this.obj.toASN1Primitive();
        }
        return null;
    }

    @Override
    public ASN1Encodable getObjectParser(int n2, boolean bl2) throws IOException {
        switch (n2) {
            case 17: {
                return ASN1Set.getInstance(this, bl2).parser();
            }
            case 16: {
                return ASN1Sequence.getInstance(this, bl2).parser();
            }
            case 4: {
                return ASN1OctetString.getInstance(this, bl2).parser();
            }
        }
        if (bl2) {
            return this.getObject();
        }
        throw new ASN1Exception("implicit tagging not implemented for tag: " + n2);
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DERTaggedObject(this.explicit, this.tagNo, this.obj);
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLTaggedObject(this.explicit, this.tagNo, this.obj);
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return "[" + this.tagNo + "]" + this.obj;
    }
}

