/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1BitString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.StreamUtil;
import java.io.IOException;

public class DLBitString
extends ASN1BitString {
    public static ASN1BitString getInstance(Object object) {
        if (object == null || object instanceof DLBitString) {
            return (DLBitString)object;
        }
        if (object instanceof DERBitString) {
            return (DERBitString)object;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1BitString)DLBitString.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1BitString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DLBitString) {
            return DLBitString.getInstance(aSN1Primitive);
        }
        return DLBitString.fromOctetString(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    protected DLBitString(byte by2, int n2) {
        this(DLBitString.toByteArray(by2), n2);
    }

    private static byte[] toByteArray(byte by2) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = by2;
        return byArray2;
    }

    public DLBitString(byte[] byArray, int n2) {
        super(byArray, n2);
    }

    public DLBitString(byte[] byArray) {
        this(byArray, 0);
    }

    public DLBitString(int n2) {
        super(DLBitString.getBytes(n2), DLBitString.getPadBits(n2));
    }

    public DLBitString(ASN1Encodable aSN1Encodable) throws IOException {
        super(aSN1Encodable.toASN1Primitive().getEncoded("DER"), 0);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.data.length + 1) + this.data.length + 1;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        byte[] byArray = this.data;
        byte[] byArray2 = new byte[this.data.length + 1];
        byte[] byArray3 = byArray2;
        byArray2[0] = (byte)this.getPadBits();
        System.arraycopy(byArray, 0, byArray3, 1, byArray3.length - 1);
        aSN1OutputStream.writeEncoded(3, byArray3);
    }

    static DLBitString fromOctetString(byte[] byArray) {
        if (byArray.length <= 0) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        byte by2 = byArray[0];
        byte[] byArray2 = new byte[byArray.length - 1];
        if (byArray2.length != 0) {
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
        }
        return new DLBitString(byArray2, (int)by2);
    }
}

