/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.pkcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Enumeration;

public class PBKDF2Params
extends ASN1Object {
    private static final AlgorithmIdentifier algid_hmacWithSHA1 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private final ASN1OctetString octStr;
    private final ASN1Integer iterationCount;
    private final ASN1Integer keyLength;
    private final AlgorithmIdentifier prf;

    public static PBKDF2Params getInstance(Object object) {
        if (object instanceof PBKDF2Params) {
            return (PBKDF2Params)object;
        }
        if (object != null) {
            return new PBKDF2Params(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PBKDF2Params(byte[] byArray, int n2) {
        this(byArray, n2, 0);
    }

    public PBKDF2Params(byte[] byArray, int n2, int n3) {
        this(byArray, n2, n3, null);
    }

    public PBKDF2Params(byte[] byArray, int n2, int n3, AlgorithmIdentifier algorithmIdentifier) {
        this.octStr = new DEROctetString(Arrays.clone(byArray));
        this.iterationCount = new ASN1Integer(n2);
        this.keyLength = n3 > 0 ? new ASN1Integer(n3) : null;
        this.prf = algorithmIdentifier;
    }

    public PBKDF2Params(byte[] byArray, int n2, AlgorithmIdentifier algorithmIdentifier) {
        this(byArray, n2, 0, algorithmIdentifier);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private PBKDF2Params(ASN1Sequence aSN1Sequence) {
        void var3_6;
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.octStr = (ASN1OctetString)enumeration.nextElement();
        this.iterationCount = (ASN1Integer)enumeration.nextElement();
        if (!enumeration.hasMoreElements()) {
            this.keyLength = null;
            this.prf = null;
            return;
        }
        Object e2 = enumeration.nextElement();
        if (e2 instanceof ASN1Integer) {
            this.keyLength = ASN1Integer.getInstance(e2);
            if (enumeration.hasMoreElements()) {
                Object e3 = enumeration.nextElement();
            } else {
                Object var3_5 = null;
            }
        } else {
            this.keyLength = null;
        }
        if (var3_6 != null) {
            this.prf = AlgorithmIdentifier.getInstance(var3_6);
            return;
        }
        this.prf = null;
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength != null) {
            return this.keyLength.getValue();
        }
        return null;
    }

    public boolean isDefaultPrf() {
        return this.prf == null || this.prf.equals(algid_hmacWithSHA1);
    }

    public AlgorithmIdentifier getPrf() {
        if (this.prf != null) {
            return this.prf;
        }
        return algid_hmacWithSHA1;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.octStr);
        aSN1EncodableVector.add(this.iterationCount);
        if (this.keyLength != null) {
            aSN1EncodableVector.add(this.keyLength);
        }
        if (this.prf != null && !this.prf.equals(algid_hmacWithSHA1)) {
            aSN1EncodableVector.add(this.prf);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

