/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.dane;

import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.dane.DANEEntry;
import com.timevale.tgtext.bouncycastle.cert.dane.DANEEntrySelector;
import com.timevale.tgtext.bouncycastle.cert.dane.DANEEntrySelectorFactory;
import com.timevale.tgtext.bouncycastle.cert.dane.DANEException;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;

public class DANEEntryFactory {
    private final DANEEntrySelectorFactory selectorFactory;

    public DANEEntryFactory(DigestCalculator digestCalculator) {
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public DANEEntry createEntry(String string, X509CertificateHolder x509CertificateHolder) throws DANEException {
        return this.createEntry(string, 3, x509CertificateHolder);
    }

    public DANEEntry createEntry(String string, int n2, X509CertificateHolder x509CertificateHolder) throws DANEException {
        if (n2 < 0 || n2 > 3) {
            throw new DANEException("unknown certificate usage: " + n2);
        }
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(string);
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n2;
        byArray2[1] = 0;
        byArray2[2] = 0;
        return new DANEEntry(dANEEntrySelector.getDomainName(), byArray2, x509CertificateHolder);
    }
}

