/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.path.validations;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Null;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.cert.CertException;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.X509ContentVerifierProviderBuilder;
import com.timevale.tgtext.bouncycastle.cert.path.CertPathValidation;
import com.timevale.tgtext.bouncycastle.cert.path.CertPathValidationContext;
import com.timevale.tgtext.bouncycastle.cert.path.CertPathValidationException;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.util.Memoable;
import java.io.IOException;

public class ParentCertIssuedValidation
implements CertPathValidation {
    private X509ContentVerifierProviderBuilder contentVerifierProvider;
    private X500Name workingIssuerName;
    private SubjectPublicKeyInfo workingPublicKey;
    private AlgorithmIdentifier workingAlgId;

    public ParentCertIssuedValidation(X509ContentVerifierProviderBuilder x509ContentVerifierProviderBuilder) {
        this.contentVerifierProvider = x509ContentVerifierProviderBuilder;
    }

    @Override
    public void validate(CertPathValidationContext certPathValidationContext, X509CertificateHolder x509CertificateHolder) throws CertPathValidationException {
        block9: {
            block7: {
                block8: {
                    if (this.workingIssuerName != null && !this.workingIssuerName.equals(x509CertificateHolder.getIssuer())) {
                        throw new CertPathValidationException("Certificate issue does not match parent");
                    }
                    if (this.workingPublicKey != null) {
                        try {
                            SubjectPublicKeyInfo subjectPublicKeyInfo = this.workingPublicKey.getAlgorithm().equals(this.workingAlgId) ? this.workingPublicKey : new SubjectPublicKeyInfo(this.workingAlgId, this.workingPublicKey.parsePublicKey());
                            if (!x509CertificateHolder.isSignatureValid(this.contentVerifierProvider.build(subjectPublicKeyInfo))) {
                                throw new CertPathValidationException("Certificate signature not for public key in parent");
                            }
                        }
                        catch (OperatorCreationException operatorCreationException) {
                            throw new CertPathValidationException("Unable to create verifier: " + operatorCreationException.getMessage(), operatorCreationException);
                        }
                        catch (CertException certException) {
                            throw new CertPathValidationException("Unable to validate signature: " + certException.getMessage(), certException);
                        }
                        catch (IOException iOException) {
                            throw new CertPathValidationException("Unable to build public key: " + iOException.getMessage(), iOException);
                        }
                    }
                    this.workingIssuerName = x509CertificateHolder.getSubject();
                    this.workingPublicKey = x509CertificateHolder.getSubjectPublicKeyInfo();
                    if (this.workingAlgId == null) break block7;
                    if (!this.workingPublicKey.getAlgorithm().getAlgorithm().equals(this.workingAlgId.getAlgorithm())) break block8;
                    if (this.isNull(this.workingPublicKey.getAlgorithm().getParameters())) break block9;
                    break block7;
                }
                this.workingAlgId = this.workingPublicKey.getAlgorithm();
                return;
            }
            this.workingAlgId = this.workingPublicKey.getAlgorithm();
        }
    }

    private boolean isNull(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable == null || aSN1Encodable instanceof ASN1Null;
    }

    @Override
    public Memoable copy() {
        ParentCertIssuedValidation parentCertIssuedValidation = new ParentCertIssuedValidation(this.contentVerifierProvider);
        new ParentCertIssuedValidation(this.contentVerifierProvider).workingAlgId = this.workingAlgId;
        parentCertIssuedValidation.workingIssuerName = this.workingIssuerName;
        parentCertIssuedValidation.workingPublicKey = this.workingPublicKey;
        return parentCertIssuedValidation;
    }

    @Override
    public void reset(Memoable memoable) {
        ParentCertIssuedValidation parentCertIssuedValidation = (ParentCertIssuedValidation)memoable;
        this.contentVerifierProvider = parentCertIssuedValidation.contentVerifierProvider;
        this.workingAlgId = parentCertIssuedValidation.workingAlgId;
        this.workingIssuerName = parentCertIssuedValidation.workingIssuerName;
        this.workingPublicKey = parentCertIssuedValidation.workingPublicKey;
    }
}

