/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.selector;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.selector.MSOutlookKeyIdCalculator;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Selector;
import java.math.BigInteger;

public class X509CertificateHolderSelector
implements Selector {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public X509CertificateHolderSelector(byte[] byArray) {
        this(null, null, byArray);
    }

    public X509CertificateHolderSelector(X500Name x500Name, BigInteger bigInteger) {
        this(x500Name, bigInteger, null);
    }

    public X509CertificateHolderSelector(X500Name x500Name, BigInteger bigInteger, byte[] byArray) {
        this.issuer = x500Name;
        this.serialNumber = bigInteger;
        this.subjectKeyId = byArray;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public byte[] getSubjectKeyIdentifier() {
        return Arrays.clone(this.subjectKeyId);
    }

    public int hashCode() {
        int n2 = Arrays.hashCode(this.subjectKeyId);
        if (this.serialNumber != null) {
            n2 ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            n2 ^= this.issuer.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof X509CertificateHolderSelector)) {
            return false;
        }
        X509CertificateHolderSelector x509CertificateHolderSelector = (X509CertificateHolderSelector)object;
        return Arrays.areEqual(this.subjectKeyId, x509CertificateHolderSelector.subjectKeyId) && this.equalsObj(this.serialNumber, x509CertificateHolderSelector.serialNumber) && this.equalsObj(this.issuer, x509CertificateHolderSelector.issuer);
    }

    private boolean equalsObj(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        return object2 == null;
    }

    public boolean match(Object object) {
        if (object instanceof X509CertificateHolder) {
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
            if (this.getSerialNumber() != null) {
                IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure());
                return issuerAndSerialNumber.getName().equals(this.issuer) && issuerAndSerialNumber.getSerialNumber().getValue().equals(this.serialNumber);
            }
            if (this.subjectKeyId != null) {
                Extension extension = x509CertificateHolder.getExtension(Extension.subjectKeyIdentifier);
                if (extension == null) {
                    return Arrays.areEqual(this.subjectKeyId, MSOutlookKeyIdCalculator.calculateKeyId(x509CertificateHolder.getSubjectPublicKeyInfo()));
                }
                byte[] byArray = ASN1OctetString.getInstance(extension.getParsedValue()).getOctets();
                return Arrays.areEqual(this.subjectKeyId, byArray);
            }
        } else if (object instanceof byte[]) {
            return Arrays.areEqual(this.subjectKeyId, (byte[])object);
        }
        return false;
    }

    @Override
    public Object clone() {
        return new X509CertificateHolderSelector(this.issuer, this.serialNumber, this.subjectKeyId);
    }
}

