/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.cms.CompressedData;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSUtils;
import com.timevale.tgtext.bouncycastle.operator.InputExpander;
import com.timevale.tgtext.bouncycastle.operator.InputExpanderProvider;
import com.timevale.tgtext.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.InputStream;

public class CMSCompressedData
implements Encodable {
    ContentInfo contentInfo;
    CompressedData comData;

    public CMSCompressedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSCompressedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSCompressedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            this.comData = CompressedData.getInstance(contentInfo.getContent());
            return;
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentInfo.getContentType();
    }

    public byte[] getContent(InputExpanderProvider inputExpanderProvider) throws CMSException {
        ContentInfo contentInfo = this.comData.getEncapContentInfo();
        ASN1OctetString aSN1OctetString = (ASN1OctetString)contentInfo.getContent();
        InputExpander inputExpander = inputExpanderProvider.get(this.comData.getCompressionAlgorithmIdentifier());
        InputStream inputStream = inputExpander.getInputStream(aSN1OctetString.getOctetStream());
        try {
            return CMSUtils.streamToByteArray(inputStream);
        }
        catch (IOException iOException) {
            throw new CMSException("exception reading compressed stream.", iOException);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

