/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.OutputLengthException;
import com.timevale.tgtext.bouncycastle.crypto.engines.DESEngine;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;

public class DESedeEngine
extends DESEngine {
    protected static final int BLOCK_SIZE = 8;
    private int[] workingKey1 = null;
    private int[] workingKey2 = null;
    private int[] workingKey3 = null;
    private boolean forEncryption;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to DESede init - " + cipherParameters.getClass().getName());
        }
        byte[] byArray = ((KeyParameter)cipherParameters).getKey();
        if (byArray.length != 24 && byArray.length != 16) {
            throw new IllegalArgumentException("key size must be 16 or 24 bytes.");
        }
        this.forEncryption = bl2;
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        this.workingKey1 = this.generateWorkingKey(bl2, byArray2);
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 8, byArray3, 0, 8);
        this.workingKey2 = this.generateWorkingKey(!bl2, byArray3);
        if (byArray.length == 24) {
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray, 16, byArray4, 0, 8);
            this.workingKey3 = this.generateWorkingKey(bl2, byArray4);
            return;
        }
        this.workingKey3 = this.workingKey1;
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (this.workingKey1 == null) {
            throw new IllegalStateException("DESede engine not initialised");
        }
        if (n2 + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] byArray3 = new byte[8];
        if (this.forEncryption) {
            this.desFunc(this.workingKey1, byArray, n2, byArray3, 0);
            this.desFunc(this.workingKey2, byArray3, 0, byArray3, 0);
            this.desFunc(this.workingKey3, byArray3, 0, byArray2, n3);
        } else {
            this.desFunc(this.workingKey3, byArray, n2, byArray3, 0);
            this.desFunc(this.workingKey2, byArray3, 0, byArray3, 0);
            this.desFunc(this.workingKey1, byArray3, 0, byArray2, n3);
        }
        return 8;
    }

    @Override
    public void reset() {
    }
}

