/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.examples;

import com.timevale.tgtext.bouncycastle.crypto.CryptoException;
import com.timevale.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.engines.DESedeEngine;
import com.timevale.tgtext.bouncycastle.crypto.generators.DESedeKeyGenerator;
import com.timevale.tgtext.bouncycastle.crypto.modes.CBCBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.SecureRandom;

public class DESExample {
    private boolean encrypt = true;
    private PaddedBufferedBlockCipher cipher = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private byte[] key = null;

    public static void main(String[] stringArray) {
        DESExample dESExample;
        boolean bl2 = true;
        if (stringArray.length < 2) {
            dESExample = new DESExample();
            System.err.println("Usage: java " + dESExample.getClass().getName() + " infile outfile [keyfile]");
            System.exit(1);
        }
        String string = "deskey.dat";
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (stringArray.length > 2) {
            bl2 = false;
            string = stringArray[2];
        }
        dESExample = new DESExample(string2, string3, string, bl2);
        dESExample.process();
    }

    public DESExample() {
    }

    public DESExample(String string, String string2, String string3, boolean bl2) {
        this.encrypt = bl2;
        try {
            this.in = new BufferedInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Input file not found [" + string + "]");
            System.exit(1);
        }
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(string2));
        }
        catch (IOException iOException) {
            System.err.println("Output file not created [" + string2 + "]");
            System.exit(1);
        }
        if (bl2) {
            try {
                SecureRandom secureRandom = null;
                try {
                    secureRandom = new SecureRandom();
                    secureRandom.setSeed("www.bouncycastle.org".getBytes());
                }
                catch (Exception exception) {
                    System.err.println("Hmmm, no SHA1PRNG, you need the Sun implementation");
                    System.exit(1);
                }
                KeyGenerationParameters keyGenerationParameters = new KeyGenerationParameters(secureRandom, 192);
                DESedeKeyGenerator dESedeKeyGenerator = new DESedeKeyGenerator();
                dESedeKeyGenerator.init(keyGenerationParameters);
                this.key = dESedeKeyGenerator.generateKey();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3));
                byte[] byArray = Hex.encode(this.key);
                bufferedOutputStream.write(byArray, 0, byArray.length);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                System.err.println("Could not decryption create key file [" + string3 + "]");
                System.exit(1);
                return;
            }
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
            int n2 = bufferedInputStream.available();
            byte[] byArray = new byte[n2];
            bufferedInputStream.read(byArray, 0, n2);
            this.key = Hex.decode(byArray);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Decryption key file not found, or not valid [" + string3 + "]");
            System.exit(1);
            return;
        }
    }

    private void process() {
        this.cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
        if (this.encrypt) {
            this.performEncrypt(this.key);
        } else {
            this.performDecrypt(this.key);
        }
        try {
            this.in.close();
            this.out.flush();
            this.out.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("exception closing resources: " + iOException.getMessage());
            return;
        }
    }

    private void performEncrypt(byte[] byArray) {
        this.cipher.init(true, new KeyParameter(byArray));
        int n2 = this.cipher.getOutputSize(47);
        byte[] byArray2 = new byte[47];
        byte[] byArray3 = new byte[n2];
        try {
            byte[] byArray4;
            int n3;
            int n4;
            while ((n4 = this.in.read(byArray2, 0, 47)) > 0) {
                n3 = this.cipher.processBytes(byArray2, 0, n4, byArray3, 0);
                if (n3 <= 0) continue;
                byArray4 = Hex.encode(byArray3, 0, n3);
                this.out.write(byArray4, 0, byArray4.length);
                this.out.write(10);
            }
            try {
                n3 = this.cipher.doFinal(byArray3, 0);
                if (n3 > 0) {
                    byArray4 = Hex.encode(byArray3, 0, n3);
                    this.out.write(byArray4, 0, byArray4.length);
                    this.out.write(10);
                }
            }
            catch (CryptoException cryptoException) {
                return;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
    }

    private void performDecrypt(byte[] byArray) {
        this.cipher.init(false, new KeyParameter(byArray));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
        try {
            int n2;
            String string;
            byte[] byArray2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                byte[] byArray3 = Hex.decode(string);
                n2 = this.cipher.processBytes(byArray3, 0, byArray3.length, byArray2 = new byte[this.cipher.getOutputSize(byArray3.length)], 0);
                if (n2 <= 0) continue;
                this.out.write(byArray2, 0, n2);
            }
            try {
                n2 = this.cipher.doFinal(byArray2, 0);
                if (n2 > 0) {
                    this.out.write(byArray2, 0, n2);
                }
            }
            catch (CryptoException cryptoException) {
                return;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
    }
}

