/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAParameterGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAValidationParameters;
import com.timevale.tgtext.bouncycastle.crypto.util.DigestFactory;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.BigIntegers;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAParametersGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private int iterations;
    private SecureRandom random;
    private boolean use186_3;
    private int usageIndex;

    public DSAParametersGenerator() {
        this(DigestFactory.createSHA1());
    }

    public DSAParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(int n2, int n3, SecureRandom secureRandom) {
        this.L = n2;
        this.N = DSAParametersGenerator.getDefaultN(n2);
        this.certainty = n3;
        this.iterations = Math.max(DSAParametersGenerator.getMinimumIterations(this.L), (n3 + 1) / 2);
        this.random = secureRandom;
        this.use186_3 = false;
        this.usageIndex = -1;
    }

    public void init(DSAParameterGenerationParameters dSAParameterGenerationParameters) {
        int n2 = dSAParameterGenerationParameters.getL();
        int n3 = dSAParameterGenerationParameters.getN();
        if (n2 < 1024 || n2 > 3072 || n2 % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (n2 == 1024 && n3 != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (n2 == 2048 && n3 != 224 && n3 != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (n2 == 3072 && n3 != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.digest.getDigestSize() << 3 < n3) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
        this.L = n2;
        this.N = n3;
        this.certainty = dSAParameterGenerationParameters.getCertainty();
        this.iterations = Math.max(DSAParametersGenerator.getMinimumIterations(n2), (this.certainty + 1) / 2);
        this.random = dSAParameterGenerationParameters.getRandom();
        this.use186_3 = true;
        this.usageIndex = dSAParameterGenerationParameters.getUsageIndex();
    }

    public DSAParameters generateParameters() {
        if (this.use186_3) {
            return this.generateParameters_FIPS186_3();
        }
        return this.generateParameters_FIPS186_2();
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_2() {
        var1_1 = new byte[20];
        var2_2 = new byte[20];
        var3_3 = new byte[20];
        var4_4 = new byte[20];
        var5_5 = (this.L - 1) / 160;
        var6_6 = new byte[this.L / 8];
        if (!(this.digest instanceof SHA1Digest)) {
            throw new IllegalStateException("can only use SHA-1 for generating FIPS 186-2 parameters");
        }
        block0: while (true) {
            this.random.nextBytes(var1_1);
            DSAParametersGenerator.hash(this.digest, var1_1, var2_2, 0);
            System.arraycopy(var1_1, 0, var3_3, 0, 20);
            DSAParametersGenerator.inc(var3_3);
            DSAParametersGenerator.hash(this.digest, var3_3, var3_3, 0);
            for (var7_8 = 0; var7_8 != 20; ++var7_8) {
                var4_4[var7_8] = (byte)(var2_2[var7_8] ^ var3_3[var7_8]);
            }
            var4_4[0] = (byte)(var4_4[0] | -128);
            var4_4[19] = (byte)(var4_4[19] | 1);
            var7_7 = new BigInteger(1, var4_4);
            if (!this.isProbablePrime(var7_7)) continue;
            var8_9 = Arrays.clone(var1_1);
            DSAParametersGenerator.inc(var8_9);
            var9_10 = 0;
            while (true) {
                if (var9_10 < 4096) ** break;
                continue block0;
                for (var10_12 = 1; var10_12 <= var5_5; ++var10_12) {
                    DSAParametersGenerator.inc(var8_9);
                    DSAParametersGenerator.hash(this.digest, var8_9, var6_6, var6_6.length - var10_12 * 20);
                }
                var10_12 = var6_6.length - var5_5 * 20;
                DSAParametersGenerator.inc(var8_9);
                DSAParametersGenerator.hash(this.digest, var8_9, var2_2, 0);
                System.arraycopy(var2_2, 20 - var10_12, var6_6, 0, var10_12);
                var6_6[0] = (byte)(var6_6[0] | -128);
                var10_11 = new BigInteger(1, var6_6);
                var11_13 = var10_11.mod(var7_7.shiftLeft(1));
                var12_14 = var10_11.subtract(var11_13.subtract(DSAParametersGenerator.ONE));
                if (var12_14.bitLength() == this.L && this.isProbablePrime(var12_14)) {
                    var13_15 = DSAParametersGenerator.calculateGenerator_FIPS186_2(var12_14, var7_7, this.random);
                    return new DSAParameters(var12_14, var7_7, var13_15, new DSAValidationParameters(var1_1, var9_10));
                }
                ++var9_10;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger6 = bigInteger.subtract(TWO);
        while ((bigInteger4 = (bigInteger3 = BigIntegers.createRandomInRange(TWO, bigInteger6, secureRandom)).modPow(bigInteger5, bigInteger)).bitLength() <= 1) {
        }
        return bigInteger4;
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_3() {
        var1_1 = this.digest;
        var2_2 = var1_1.getDigestSize() << 3;
        var3_3 = this.N;
        var4_4 = new byte[var3_3 / 8];
        var5_5 = (this.L - 1) / var2_2;
        var6_6 = new byte[this.L / 8];
        var7_7 = new byte[var1_1.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(var4_4);
            DSAParametersGenerator.hash(var1_1, var4_4, var7_7, 0);
            var8_8 = new BigInteger(1, var7_7).mod(DSAParametersGenerator.ONE.shiftLeft(this.N - 1));
            var9_9 = var8_8.setBit(0).setBit(this.N - 1);
            if (!this.isProbablePrime(var9_9)) continue;
            var10_10 = Arrays.clone(var4_4);
            var11_11 = 4 * this.L;
            var12_12 = 0;
            while (true) {
                if (var12_12 < var11_11) ** break;
                continue block0;
                for (var13_14 = 1; var13_14 <= var5_5; ++var13_14) {
                    DSAParametersGenerator.inc(var10_10);
                    DSAParametersGenerator.hash(var1_1, var10_10, var6_6, var6_6.length - var13_14 * var7_7.length);
                }
                var13_14 = var6_6.length - var5_5 * var7_7.length;
                DSAParametersGenerator.inc(var10_10);
                DSAParametersGenerator.hash(var1_1, var10_10, var7_7, 0);
                System.arraycopy(var7_7, var7_7.length - var13_14, var6_6, 0, var13_14);
                var6_6[0] = (byte)(var6_6[0] | -128);
                var13_13 = new BigInteger(1, var6_6);
                var14_15 = var13_13.mod(var9_9.shiftLeft(1));
                var15_16 = var13_13.subtract(var14_15.subtract(DSAParametersGenerator.ONE));
                if (var15_16.bitLength() == this.L && this.isProbablePrime(var15_16)) {
                    if (this.usageIndex >= 0 && (var16_17 = DSAParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(var1_1, var15_16, var9_9, var4_4, this.usageIndex)) != null) {
                        return new DSAParameters(var15_16, var9_9, var16_17, new DSAValidationParameters(var4_4, var12_12, this.usageIndex));
                    }
                    var16_17 = DSAParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(var15_16, var9_9, this.random);
                    return new DSAParameters(var15_16, var9_9, var16_17, new DSAValidationParameters(var4_4, var12_12));
                }
                ++var12_12;
            }
            break;
        }
    }

    private boolean isProbablePrime(BigInteger bigInteger) {
        return bigInteger.isProbablePrime(this.certainty);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        return DSAParametersGenerator.calculateGenerator_FIPS186_2(bigInteger, bigInteger2, secureRandom);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2) {
        BigInteger bigInteger3 = bigInteger.subtract(ONE).divide(bigInteger2);
        byte[] byArray2 = Hex.decode("6767656E");
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1 + 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byArray3[byArray3.length - 3] = (byte)n2;
        byte[] byArray4 = new byte[digest.getDigestSize()];
        for (int i2 = 1; i2 < 65536; ++i2) {
            DSAParametersGenerator.inc(byArray3);
            DSAParametersGenerator.hash(digest, byArray3, byArray4, 0);
            BigInteger bigInteger4 = new BigInteger(1, byArray4);
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
            if (bigInteger5.compareTo(TWO) < 0) continue;
            return bigInteger5;
        }
        return null;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2, int n2) {
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, n2);
    }

    private static int getDefaultN(int n2) {
        if (n2 > 1024) {
            return 256;
        }
        return 160;
    }

    private static int getMinimumIterations(int n2) {
        if (n2 <= 1024) {
            return 40;
        }
        return 48 + 8 * ((n2 - 1) / 1024);
    }

    private static void inc(byte[] byArray) {
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byte by2;
            byArray[i2] = by2 = (byte)(byArray[i2] + 1);
            if (by2 != 0) break;
        }
    }
}

