/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.params.GOST3410Parameters;
import com.timevale.tgtext.bouncycastle.crypto.params.GOST3410ValidationParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410ParametersGenerator {
    private int size;
    private int typeproc;
    private SecureRandom init_random;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    public void init(int n2, int n3, SecureRandom secureRandom) {
        this.size = n2;
        this.typeproc = n3;
        this.init_random = secureRandom;
    }

    private int procedure_A(int n2, int n3, BigInteger[] bigIntegerArray, int n4) {
        while (n2 < 0 || n2 > 65536) {
            n2 = this.init_random.nextInt() / 32768;
        }
        while (n3 < 0 || n3 > 65536 || n3 / 2 == 0) {
            n3 = this.init_random.nextInt() / 32768 + 1;
        }
        BigInteger bigInteger = new BigInteger(Integer.toString(n3));
        BigInteger bigInteger2 = new BigInteger("19381");
        BigInteger[] bigIntegerArray2 = new BigInteger[1];
        BigInteger[] bigIntegerArray3 = bigIntegerArray2;
        bigIntegerArray2[0] = new BigInteger(Integer.toString(n2));
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = n4;
        int n5 = 0;
        int n6 = 0;
        while (nArray2[n6] >= 17) {
            int[] nArray3 = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            nArray2 = new int[nArray3.length];
            System.arraycopy(nArray3, 0, nArray2, 0, nArray3.length);
            nArray2[n6 + 1] = nArray2[n6] / 2;
            n5 = n6 + 1;
            ++n6;
        }
        BigInteger[] bigIntegerArray4 = new BigInteger[n5 + 1];
        BigInteger[] bigIntegerArray5 = bigIntegerArray4;
        bigIntegerArray4[n5] = new BigInteger("8003", 16);
        int n7 = n5 - 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = nArray2[n7] / 16;
            block4: while (true) {
                BigInteger[] bigIntegerArray6 = new BigInteger[bigIntegerArray3.length];
                System.arraycopy(bigIntegerArray3, 0, bigIntegerArray6, 0, bigIntegerArray3.length);
                bigIntegerArray3 = new BigInteger[n8 + 1];
                System.arraycopy(bigIntegerArray6, 0, bigIntegerArray3, 0, bigIntegerArray6.length);
                for (int i3 = 0; i3 < n8; ++i3) {
                    bigIntegerArray3[i3 + 1] = bigIntegerArray3[i3].multiply(bigInteger2).add(bigInteger).mod(TWO.pow(16));
                }
                BigInteger bigInteger3 = new BigInteger("0");
                for (int i4 = 0; i4 < n8; ++i4) {
                    bigInteger3 = bigInteger3.add(bigIntegerArray3[i4].multiply(TWO.pow(i4 * 16)));
                }
                bigIntegerArray3[0] = bigIntegerArray3[n8];
                BigInteger bigInteger4 = TWO.pow(nArray2[n7] - 1).divide(bigIntegerArray5[n7 + 1]).add(TWO.pow(nArray2[n7] - 1).multiply(bigInteger3).divide(bigIntegerArray5[n7 + 1].multiply(TWO.pow(n8 * 16))));
                if (bigInteger4.mod(TWO).compareTo(ONE) == 0) {
                    bigInteger4 = bigInteger4.add(ONE);
                }
                int n9 = 0;
                while (true) {
                    bigIntegerArray5[n7] = bigIntegerArray5[n7 + 1].multiply(bigInteger4.add(BigInteger.valueOf(n9))).add(ONE);
                    if (bigIntegerArray5[n7].compareTo(TWO.pow(nArray2[n7])) == 1) continue block4;
                    if (TWO.modPow(bigIntegerArray5[n7 + 1].multiply(bigInteger4.add(BigInteger.valueOf(n9))), bigIntegerArray5[n7]).compareTo(ONE) == 0 && TWO.modPow(bigInteger4.add(BigInteger.valueOf(n9)), bigIntegerArray5[n7]).compareTo(ONE) != 0) break block4;
                    n9 += 2;
                }
                break;
            }
            if (--n7 >= 0) continue;
            bigIntegerArray[0] = bigIntegerArray5[0];
            bigIntegerArray[1] = bigIntegerArray5[1];
            return bigIntegerArray3[0].intValue();
        }
        return bigIntegerArray3[0].intValue();
    }

    private long procedure_Aa(long l2, long l3, BigInteger[] bigIntegerArray, int n2) {
        while (l2 < 0L || l2 > 0x100000000L) {
            l2 = this.init_random.nextInt() << 1;
        }
        while (l3 < 0L || l3 > 0x100000000L || l3 / 2L == 0L) {
            l3 = (this.init_random.nextInt() << 1) + 1;
        }
        BigInteger bigInteger = new BigInteger(Long.toString(l3));
        BigInteger bigInteger2 = new BigInteger("97781173");
        BigInteger[] bigIntegerArray2 = new BigInteger[1];
        BigInteger[] bigIntegerArray3 = bigIntegerArray2;
        bigIntegerArray2[0] = new BigInteger(Long.toString(l2));
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 0;
        int n4 = 0;
        while (nArray2[n4] >= 33) {
            int[] nArray3 = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            nArray2 = new int[nArray3.length];
            System.arraycopy(nArray3, 0, nArray2, 0, nArray3.length);
            nArray2[n4 + 1] = nArray2[n4] / 2;
            n3 = n4 + 1;
            ++n4;
        }
        BigInteger[] bigIntegerArray4 = new BigInteger[n3 + 1];
        BigInteger[] bigIntegerArray5 = bigIntegerArray4;
        bigIntegerArray4[n3] = new BigInteger("8000000B", 16);
        int n5 = n3 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = nArray2[n5] / 32;
            block4: while (true) {
                BigInteger[] bigIntegerArray6 = new BigInteger[bigIntegerArray3.length];
                System.arraycopy(bigIntegerArray3, 0, bigIntegerArray6, 0, bigIntegerArray3.length);
                bigIntegerArray3 = new BigInteger[n6 + 1];
                System.arraycopy(bigIntegerArray6, 0, bigIntegerArray3, 0, bigIntegerArray6.length);
                for (int i3 = 0; i3 < n6; ++i3) {
                    bigIntegerArray3[i3 + 1] = bigIntegerArray3[i3].multiply(bigInteger2).add(bigInteger).mod(TWO.pow(32));
                }
                BigInteger bigInteger3 = new BigInteger("0");
                for (int i4 = 0; i4 < n6; ++i4) {
                    bigInteger3 = bigInteger3.add(bigIntegerArray3[i4].multiply(TWO.pow(i4 * 32)));
                }
                bigIntegerArray3[0] = bigIntegerArray3[n6];
                BigInteger bigInteger4 = TWO.pow(nArray2[n5] - 1).divide(bigIntegerArray5[n5 + 1]).add(TWO.pow(nArray2[n5] - 1).multiply(bigInteger3).divide(bigIntegerArray5[n5 + 1].multiply(TWO.pow(n6 * 32))));
                if (bigInteger4.mod(TWO).compareTo(ONE) == 0) {
                    bigInteger4 = bigInteger4.add(ONE);
                }
                int n7 = 0;
                while (true) {
                    bigIntegerArray5[n5] = bigIntegerArray5[n5 + 1].multiply(bigInteger4.add(BigInteger.valueOf(n7))).add(ONE);
                    if (bigIntegerArray5[n5].compareTo(TWO.pow(nArray2[n5])) == 1) continue block4;
                    if (TWO.modPow(bigIntegerArray5[n5 + 1].multiply(bigInteger4.add(BigInteger.valueOf(n7))), bigIntegerArray5[n5]).compareTo(ONE) == 0 && TWO.modPow(bigInteger4.add(BigInteger.valueOf(n7)), bigIntegerArray5[n5]).compareTo(ONE) != 0) break block4;
                    n7 += 2;
                }
                break;
            }
            if (--n5 >= 0) continue;
            bigIntegerArray[0] = bigIntegerArray5[0];
            bigIntegerArray[1] = bigIntegerArray5[1];
            return bigIntegerArray3[0].longValue();
        }
        return bigIntegerArray3[0].longValue();
    }

    /*
     * Unable to fully structure code
     */
    private void procedure_B(int var1_1, int var2_2, BigInteger[] var3_3) {
        while (var1_1 < 0 || var1_1 > 65536) {
            var1_1 = this.init_random.nextInt() / 32768;
        }
        while (var2_2 < 0 || var2_2 > 65536 || var2_2 / 2 == 0) {
            var2_2 = this.init_random.nextInt() / 32768 + 1;
        }
        var4_4 = new BigInteger[2];
        var8_5 = new BigInteger(Integer.toString(var2_2));
        var9_6 = new BigInteger("19381");
        var1_1 = this.procedure_A(var1_1, var2_2, var4_4, 256);
        var5_7 = var4_4[0];
        var1_1 = this.procedure_A(var1_1, var2_2, var4_4, 512);
        var6_8 = var4_4[0];
        v0 = new BigInteger[65];
        var10_9 = v0;
        v0[0] = new BigInteger(Integer.toString(var1_1));
        while (true) {
            for (var11_12 = 0; var11_12 < 64; ++var11_12) {
                var10_9[var11_12 + 1] = var10_9[var11_12].multiply(var9_6).add(var8_5).mod(GOST3410ParametersGenerator.TWO.pow(16));
            }
            var11_11 = new BigInteger("0");
            for (var12_14 = 0; var12_14 < 64; ++var12_14) {
                var11_11 = var11_11.add(var10_9[var12_14].multiply(GOST3410ParametersGenerator.TWO.pow(var12_14 * 16)));
            }
            var10_9[0] = var10_9[64];
            var12_13 = GOST3410ParametersGenerator.TWO.pow(1023).divide(var5_7.multiply(var6_8)).add(GOST3410ParametersGenerator.TWO.pow(1023).multiply(var11_11).divide(var5_7.multiply(var6_8).multiply(GOST3410ParametersGenerator.TWO.pow(1024))));
            if (var12_13.mod(GOST3410ParametersGenerator.TWO).compareTo(GOST3410ParametersGenerator.ONE) == 0) {
                var12_13 = var12_13.add(GOST3410ParametersGenerator.ONE);
            }
            var13_15 = 0;
            while (true) {
                if ((var7_10 = var5_7.multiply(var6_8).multiply(var12_13.add(BigInteger.valueOf(var13_15))).add(GOST3410ParametersGenerator.ONE)).compareTo(GOST3410ParametersGenerator.TWO.pow(1024)) == 1) ** continue;
                if (GOST3410ParametersGenerator.TWO.modPow(var5_7.multiply(var6_8).multiply(var12_13.add(BigInteger.valueOf(var13_15))), var7_10).compareTo(GOST3410ParametersGenerator.ONE) == 0 && GOST3410ParametersGenerator.TWO.modPow(var5_7.multiply(var12_13.add(BigInteger.valueOf(var13_15))), var7_10).compareTo(GOST3410ParametersGenerator.ONE) != 0) {
                    var3_3[0] = var7_10;
                    var3_3[1] = var5_7;
                    return;
                }
                var13_15 += 2;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void procedure_Bb(long var1_1, long var3_2, BigInteger[] var5_3) {
        while (var1_1 < 0L || var1_1 > 0x100000000L) {
            var1_1 = this.init_random.nextInt() << 1;
        }
        while (var3_2 < 0L || var3_2 > 0x100000000L || var3_2 / 2L == 0L) {
            var3_2 = (this.init_random.nextInt() << 1) + 1;
        }
        var6_4 = new BigInteger[2];
        var10_5 = new BigInteger(Long.toString(var3_2));
        var11_6 = new BigInteger("97781173");
        var1_1 = this.procedure_Aa(var1_1, var3_2, var6_4, 256);
        var7_7 = var6_4[0];
        var1_1 = this.procedure_Aa(var1_1, var3_2, var6_4, 512);
        var8_8 = var6_4[0];
        v0 = new BigInteger[33];
        var12_9 = v0;
        v0[0] = new BigInteger(Long.toString(var1_1));
        while (true) {
            for (var13_12 = 0; var13_12 < 32; ++var13_12) {
                var12_9[var13_12 + 1] = var12_9[var13_12].multiply(var11_6).add(var10_5).mod(GOST3410ParametersGenerator.TWO.pow(32));
            }
            var13_11 = new BigInteger("0");
            for (var14_14 = 0; var14_14 < 32; ++var14_14) {
                var13_11 = var13_11.add(var12_9[var14_14].multiply(GOST3410ParametersGenerator.TWO.pow(var14_14 * 32)));
            }
            var12_9[0] = var12_9[32];
            var14_13 = GOST3410ParametersGenerator.TWO.pow(1023).divide(var7_7.multiply(var8_8)).add(GOST3410ParametersGenerator.TWO.pow(1023).multiply(var13_11).divide(var7_7.multiply(var8_8).multiply(GOST3410ParametersGenerator.TWO.pow(1024))));
            if (var14_13.mod(GOST3410ParametersGenerator.TWO).compareTo(GOST3410ParametersGenerator.ONE) == 0) {
                var14_13 = var14_13.add(GOST3410ParametersGenerator.ONE);
            }
            var15_15 = 0;
            while (true) {
                if ((var9_10 = var7_7.multiply(var8_8).multiply(var14_13.add(BigInteger.valueOf(var15_15))).add(GOST3410ParametersGenerator.ONE)).compareTo(GOST3410ParametersGenerator.TWO.pow(1024)) == 1) ** continue;
                if (GOST3410ParametersGenerator.TWO.modPow(var7_7.multiply(var8_8).multiply(var14_13.add(BigInteger.valueOf(var15_15))), var9_10).compareTo(GOST3410ParametersGenerator.ONE) == 0 && GOST3410ParametersGenerator.TWO.modPow(var7_7.multiply(var14_13.add(BigInteger.valueOf(var15_15))), var9_10).compareTo(GOST3410ParametersGenerator.ONE) != 0) {
                    var5_3[0] = var9_10;
                    var5_3[1] = var7_7;
                    return;
                }
                var15_15 += 2;
            }
            break;
        }
    }

    private BigInteger procedure_C(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(ONE);
        BigInteger bigInteger6 = bigInteger5.divide(bigInteger2);
        int n2 = bigInteger.bitLength();
        while ((bigInteger4 = new BigInteger(n2, this.init_random)).compareTo(ONE) <= 0 || bigInteger4.compareTo(bigInteger5) >= 0 || (bigInteger3 = bigInteger4.modPow(bigInteger6, bigInteger)).compareTo(ONE) == 0) {
        }
        return bigInteger3;
    }

    public GOST3410Parameters generateParameters() {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        if (this.typeproc == 1) {
            int n2 = this.init_random.nextInt();
            int n3 = this.init_random.nextInt();
            switch (this.size) {
                case 512: {
                    this.procedure_A(n2, n3, bigIntegerArray, 512);
                    break;
                }
                case 1024: {
                    this.procedure_B(n2, n3, bigIntegerArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Ooops! key size 512 or 1024 bit.");
                }
            }
            BigInteger bigInteger = bigIntegerArray[0];
            BigInteger bigInteger2 = bigIntegerArray[1];
            BigInteger bigInteger3 = this.procedure_C(bigInteger, bigInteger2);
            return new GOST3410Parameters(bigInteger, bigInteger2, bigInteger3, new GOST3410ValidationParameters(n2, n3));
        }
        long l2 = this.init_random.nextLong();
        long l3 = this.init_random.nextLong();
        switch (this.size) {
            case 512: {
                this.procedure_Aa(l2, l3, bigIntegerArray, 512);
                break;
            }
            case 1024: {
                this.procedure_Bb(l2, l3, bigIntegerArray);
                break;
            }
            default: {
                throw new IllegalStateException("Ooops! key size 512 or 1024 bit.");
            }
        }
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger4 = bigIntegerArray[1];
        BigInteger bigInteger5 = this.procedure_C(bigInteger, bigInteger4);
        return new GOST3410Parameters(bigInteger, bigInteger4, bigInteger5, new GOST3410ValidationParameters(l2, l3));
    }
}

