/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.PBEParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA256Digest;
import com.timevale.tgtext.bouncycastle.crypto.engines.Salsa20Engine;
import com.timevale.tgtext.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Pack;

public class SCrypt {
    public static byte[] generate(byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5) {
        if (byArray == null) {
            throw new IllegalArgumentException("Passphrase P must be provided.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Salt S must be provided.");
        }
        if (n2 <= 1 || !SCrypt.isPowerOf2(n2)) {
            throw new IllegalArgumentException("Cost parameter N must be > 1 and a power of 2");
        }
        if (n3 == 1 && n2 >= 65536) {
            throw new IllegalArgumentException("Cost parameter N must be > 1 and < 65536.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("Block size r must be >= 1.");
        }
        int n6 = Integer.MAX_VALUE / (n3 * 128 << 3);
        if (n4 <= 0 || n4 > n6) {
            throw new IllegalArgumentException("Parallelisation parameter p must be >= 1 and <= " + n6 + " (based on block size r of " + n3 + ")");
        }
        if (n5 <= 0) {
            throw new IllegalArgumentException("Generated key length dkLen must be >= 1.");
        }
        return SCrypt.MFcrypt(byArray, byArray2, n2, n3, n4, n5);
    }

    private static byte[] MFcrypt(byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5) {
        byte[] byArray3;
        int n6 = n3 << 7;
        byte[] byArray4 = SCrypt.SingleIterationPBKDF2(byArray, byArray2, n4 * n6);
        int[] nArray = null;
        try {
            int n7 = byArray4.length >>> 2;
            nArray = new int[n7];
            Pack.littleEndianToInt(byArray4, 0, nArray);
            int n8 = n6 >>> 2;
            for (int i2 = 0; i2 < n7; i2 += n8) {
                SCrypt.SMix(nArray, i2, n2, n3);
            }
            Pack.intToLittleEndian(nArray, byArray4, 0);
            byArray3 = SCrypt.SingleIterationPBKDF2(byArray, byArray4, n5);
        }
        catch (Throwable throwable) {
            SCrypt.Clear(byArray4);
            SCrypt.Clear(nArray);
            throw throwable;
        }
        SCrypt.Clear(byArray4);
        SCrypt.Clear(nArray);
        return byArray3;
    }

    private static byte[] SingleIterationPBKDF2(byte[] byArray, byte[] byArray2, int n2) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(new SHA256Digest());
        pKCS5S2ParametersGenerator.init(byArray, byArray2, 1);
        KeyParameter keyParameter = (KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedMacParameters(n2 << 3);
        return keyParameter.getKey();
    }

    private static void SMix(int[] nArray, int n2, int n3, int n4) {
        int n5 = n4 << 5;
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[n5];
        int[] nArray5 = new int[n5];
        int[][] nArrayArray = new int[n3][];
        try {
            int n6;
            System.arraycopy(nArray, n2, nArray5, 0, n5);
            for (n6 = 0; n6 < n3; ++n6) {
                nArrayArray[n6] = Arrays.clone(nArray5);
                SCrypt.BlockMix(nArray5, nArray2, nArray3, nArray4, n4);
            }
            n6 = n3 - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n7 = nArray5[n5 - 16] & n6;
                SCrypt.Xor(nArray5, nArrayArray[n7], 0, nArray5);
                SCrypt.BlockMix(nArray5, nArray2, nArray3, nArray4, n4);
            }
            System.arraycopy(nArray5, 0, nArray, n2, n5);
        }
        catch (Throwable throwable) {
            SCrypt.ClearAll(nArrayArray);
            SCrypt.ClearAll(new int[][]{nArray5, nArray2, nArray3, nArray4});
            throw throwable;
        }
        SCrypt.ClearAll(nArrayArray);
        SCrypt.ClearAll(new int[][]{nArray5, nArray2, nArray3, nArray4});
    }

    private static void BlockMix(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n2) {
        System.arraycopy(nArray, nArray.length - 16, nArray2, 0, 16);
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray.length >>> 1;
        for (int i2 = 2 * n2; i2 > 0; --i2) {
            SCrypt.Xor(nArray2, nArray, n3, nArray3);
            Salsa20Engine.salsaCore(8, nArray3, nArray2);
            System.arraycopy(nArray2, 0, nArray4, n4, 16);
            n4 = n5 + n3 - n4;
            n3 += 16;
        }
        System.arraycopy(nArray4, 0, nArray, 0, nArray4.length);
    }

    private static void Xor(int[] nArray, int[] nArray2, int n2, int[] nArray3) {
        for (int i2 = nArray3.length - 1; i2 >= 0; --i2) {
            nArray3[i2] = nArray[i2] ^ nArray2[n2 + i2];
        }
    }

    private static void Clear(byte[] byArray) {
        if (byArray != null) {
            Arrays.fill(byArray, (byte)0);
        }
    }

    private static void Clear(int[] nArray) {
        if (nArray != null) {
            Arrays.fill(nArray, 0);
        }
    }

    private static void ClearAll(int[][] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            SCrypt.Clear(nArray[i2]);
        }
    }

    private static boolean isPowerOf2(int n2) {
        return (n2 & n2 - 1) == 0;
    }
}

