/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.signers;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.math.ec.ECAlgorithms;
import com.timevale.tgtext.bouncycastle.math.ec.ECConstants;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNRSigner
implements DSA {
    private boolean forSigning;
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forSigning = bl2;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                this.key = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
                return;
            }
            this.random = new SecureRandom();
            this.key = (ECPrivateKeyParameters)cipherParameters;
            return;
        }
        this.key = (ECPublicKeyParameters)cipherParameters;
    }

    @Override
    public BigInteger[] generateSignature(byte[] byArray) {
        Object object;
        AsymmetricCipherKeyPair asymmetricCipherKeyPair;
        Object object2;
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger;
        if (!this.forSigning) {
            throw new IllegalStateException("not initialised for signing");
        }
        BigInteger bigInteger2 = ((ECPrivateKeyParameters)this.key).getParameters().getN();
        int n2 = bigInteger2.bitLength();
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        int n3 = bigInteger3.bitLength();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.key;
        if (n3 > n2) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        do {
            object = new ECKeyPairGenerator();
            ((ECKeyPairGenerator)object).init(new ECKeyGenerationParameters(eCPrivateKeyParameters.getParameters(), this.random));
        } while ((bigInteger = (bigIntegerArray = ((ECPublicKeyParameters)(object2 = (ECPublicKeyParameters)(asymmetricCipherKeyPair = ((ECKeyPairGenerator)object).generateKeyPair()).getPublic())).getQ().getAffineXCoord().toBigInteger()).add(bigInteger3).mod(bigInteger2)).equals(ECConstants.ZERO));
        object = eCPrivateKeyParameters.getD();
        object2 = ((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getD();
        BigInteger bigInteger4 = ((BigInteger)object2).subtract(bigInteger.multiply((BigInteger)object)).mod(bigInteger2);
        BigInteger[] bigIntegerArray2 = new BigInteger[2];
        bigIntegerArray = bigIntegerArray2;
        bigIntegerArray2[0] = bigInteger;
        bigIntegerArray[1] = bigInteger4;
        return bigIntegerArray;
    }

    @Override
    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying");
        }
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)this.key;
        BigInteger bigInteger3 = eCPublicKeyParameters.getParameters().getN();
        int n2 = bigInteger3.bitLength();
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        int n3 = bigInteger4.bitLength();
        if (n3 > n2) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        if (bigInteger.compareTo(ECConstants.ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ECConstants.ZERO) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        ECPoint eCPoint2 = eCPublicKeyParameters.getParameters().getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger2, eCPoint = eCPublicKeyParameters.getQ(), bigInteger).normalize();
        if (eCPoint3.isInfinity()) {
            return false;
        }
        BigInteger bigInteger5 = eCPoint3.getAffineXCoord().toBigInteger();
        BigInteger bigInteger6 = bigInteger.subtract(bigInteger5).mod(bigInteger3);
        return bigInteger6.equals(bigInteger4);
    }
}

