/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.tls.AbstractTlsPeer;
import com.timevale.tgtext.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.timevale.tgtext.bouncycastle.crypto.tls.NewSessionTicket;
import com.timevale.tgtext.bouncycastle.crypto.tls.ProtocolVersion;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipher;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipherFactory;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClient;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCompression;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsECCUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsNullCompression;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSession;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsCipherFactory cipherFactory;
    protected TlsClientContext context;
    protected Vector supportedSignatureAlgorithms;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;

    public AbstractTlsClient() {
        this(new DefaultTlsCipherFactory());
    }

    public AbstractTlsClient(TlsCipherFactory tlsCipherFactory) {
        this.cipherFactory = tlsCipherFactory;
    }

    protected boolean allowUnexpectedServerExtension(Integer n2, byte[] byArray) throws IOException {
        switch (n2) {
            case 10: {
                TlsECCUtils.readSupportedEllipticCurvesExtension(byArray);
                return true;
            }
            case 11: {
                TlsECCUtils.readSupportedPointFormatsExtension(byArray);
                return true;
            }
        }
        return false;
    }

    protected void checkForUnexpectedServerExtension(Hashtable hashtable, Integer n2) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, n2);
        if (byArray != null && !this.allowUnexpectedServerExtension(n2, byArray)) {
            throw new TlsFatalAlert(47);
        }
    }

    @Override
    public void init(TlsClientContext tlsClientContext) {
        this.context = tlsClientContext;
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public ProtocolVersion getClientHelloRecordLayerVersion() {
        return this.getClientVersion();
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = null;
        ProtocolVersion protocolVersion = this.context.getClientVersion();
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            this.supportedSignatureAlgorithms = TlsUtils.getDefaultSupportedSignatureAlgorithms();
            hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(null);
            TlsUtils.addSignatureAlgorithmsExtension(hashtable, this.supportedSignatureAlgorithms);
        }
        if (TlsECCUtils.containsECCCipherSuites(this.getCipherSuites())) {
            this.namedCurves = new int[]{23, 24};
            this.clientECPointFormats = new short[]{0, 1, 2};
            hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(hashtable);
            TlsECCUtils.addSupportedEllipticCurvesExtension(hashtable, this.namedCurves);
            TlsECCUtils.addSupportedPointFormatsExtension(hashtable, this.clientECPointFormats);
        }
        return hashtable;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
        if (!this.getMinimumVersion().isEqualOrEarlierVersionOf(protocolVersion)) {
            throw new TlsFatalAlert(70);
        }
    }

    @Override
    public short[] getCompressionMethods() {
        return new short[]{0};
    }

    @Override
    public void notifySessionID(byte[] byArray) {
    }

    @Override
    public void notifySelectedCipherSuite(int n2) {
        this.selectedCipherSuite = n2;
    }

    @Override
    public void notifySelectedCompressionMethod(short s2) {
        this.selectedCompressionMethod = s2;
    }

    @Override
    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (hashtable != null) {
            this.checkForUnexpectedServerExtension(hashtable, TlsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(hashtable, TlsECCUtils.EXT_elliptic_curves);
            if (TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
                this.serverECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(hashtable);
            } else {
                this.checkForUnexpectedServerExtension(hashtable, TlsECCUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_padding);
        }
    }

    @Override
    public void processServerSupplementalData(Vector vector) throws IOException {
        if (vector != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        int n2 = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int n3 = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        return this.cipherFactory.createCipher(this.context, n2, n3);
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

