/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.tls.Certificate;
import com.timevale.tgtext.bouncycastle.crypto.tls.DigitallySigned;
import com.timevale.tgtext.bouncycastle.crypto.tls.ProtocolVersion;
import com.timevale.tgtext.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsKeyExchange;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public abstract class AbstractTlsKeyExchange
implements TlsKeyExchange {
    protected int keyExchange;
    protected Vector supportedSignatureAlgorithms;
    protected TlsContext context;

    protected AbstractTlsKeyExchange(int n2, Vector vector) {
        this.keyExchange = n2;
        this.supportedSignatureAlgorithms = vector;
    }

    protected DigitallySigned parseSignature(InputStream inputStream) throws IOException {
        DigitallySigned digitallySigned = DigitallySigned.parse(this.context, inputStream);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null) {
            TlsUtils.verifySupportedSignatureAlgorithm(this.supportedSignatureAlgorithms, signatureAndHashAlgorithm);
        }
        return digitallySigned;
    }

    @Override
    public void init(TlsContext tlsContext) {
        this.context = tlsContext;
        ProtocolVersion protocolVersion = tlsContext.getClientVersion();
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            if (this.supportedSignatureAlgorithms == null) {
                switch (this.keyExchange) {
                    case 3: 
                    case 7: 
                    case 22: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultDSSSignatureAlgorithms();
                        return;
                    }
                    case 16: 
                    case 17: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultECDSASignatureAlgorithms();
                        return;
                    }
                    case 1: 
                    case 5: 
                    case 9: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 23: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultRSASignatureAlgorithms();
                        return;
                    }
                    case 13: 
                    case 14: 
                    case 21: 
                    case 24: {
                        return;
                    }
                }
                throw new IllegalStateException("unsupported key exchange algorithm");
            }
        } else if (this.supportedSignatureAlgorithms != null) {
            throw new IllegalStateException("supported_signature_algorithms not allowed for " + protocolVersion);
        }
    }

    @Override
    public void processServerCertificate(Certificate certificate) throws IOException {
    }

    @Override
    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        this.processServerCertificate(tlsCredentials.getCertificate());
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return false;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(80);
        }
        return null;
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCertificate(Certificate certificate) throws IOException {
    }

    @Override
    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }
}

