/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.Mac;
import com.timevale.tgtext.bouncycastle.crypto.StreamCipher;
import com.timevale.tgtext.bouncycastle.crypto.engines.ChaCha7539Engine;
import com.timevale.tgtext.bouncycastle.crypto.macs.Poly1305;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipher;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Pack;
import java.io.IOException;

public class Chacha20Poly1305
implements TlsCipher {
    private static final byte[] ZEROES = new byte[15];
    protected TlsContext context;
    protected ChaCha7539Engine encryptCipher;
    protected ChaCha7539Engine decryptCipher;
    protected byte[] encryptIV;
    protected byte[] decryptIV;

    public Chacha20Poly1305(TlsContext tlsContext) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        if (!TlsUtils.isTLSv12(tlsContext)) {
            throw new TlsFatalAlert(80);
        }
        this.context = tlsContext;
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, 88);
        KeyParameter keyParameter3 = new KeyParameter(byArray, 0, 32);
        KeyParameter keyParameter4 = new KeyParameter(byArray, 32, 32);
        byte[] byArray2 = Arrays.copyOfRange(byArray, 64, 76);
        byte[] byArray3 = Arrays.copyOfRange(byArray, 76, 88);
        this.encryptCipher = new ChaCha7539Engine();
        this.decryptCipher = new ChaCha7539Engine();
        if (tlsContext.isServer()) {
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
            this.encryptIV = byArray3;
            this.decryptIV = byArray2;
        } else {
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
            this.encryptIV = byArray2;
            this.decryptIV = byArray3;
        }
        this.encryptCipher.init(true, new ParametersWithIV(keyParameter2, this.encryptIV));
        this.decryptCipher.init(false, new ParametersWithIV(keyParameter, this.decryptIV));
    }

    @Override
    public int getPlaintextLimit(int n2) {
        return n2 - 16;
    }

    @Override
    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        KeyParameter keyParameter = this.initRecord(this.encryptCipher, true, l2, this.encryptIV);
        byte[] byArray2 = new byte[n3 + 16];
        this.encryptCipher.processBytes(byArray, n2, n3, byArray2, 0);
        byte[] byArray3 = this.getAdditionalData(l2, s2, n3);
        byte[] byArray4 = this.calculateRecordMAC(keyParameter, byArray3, byArray2, 0, n3);
        System.arraycopy(byArray4, 0, byArray2, n3, byArray4.length);
        return byArray2;
    }

    @Override
    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2;
        int n4;
        byte[] byArray3;
        if (this.getPlaintextLimit(n3) < 0) {
            throw new TlsFatalAlert(50);
        }
        KeyParameter keyParameter = this.initRecord(this.decryptCipher, false, l2, this.decryptIV);
        byte[] byArray4 = this.calculateRecordMAC(keyParameter, byArray3 = this.getAdditionalData(l2, s2, n4 = n3 - 16), byArray, n2, n4);
        if (!Arrays.constantTimeAreEqual(byArray4, byArray2 = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3))) {
            throw new TlsFatalAlert(20);
        }
        byte[] byArray5 = new byte[n4];
        this.decryptCipher.processBytes(byArray, n2, n4, byArray5, 0);
        return byArray5;
    }

    protected KeyParameter initRecord(StreamCipher streamCipher, boolean bl2, long l2, byte[] byArray) {
        byte[] byArray2 = this.calculateNonce(l2, byArray);
        streamCipher.init(bl2, new ParametersWithIV(null, byArray2));
        return this.generateRecordMACKey(streamCipher);
    }

    protected byte[] calculateNonce(long l2, byte[] byArray) {
        byte[] byArray2 = new byte[12];
        TlsUtils.writeUint64(l2, byArray2, 4);
        for (int i2 = 0; i2 < 12; ++i2) {
            int n2 = i2;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray[i2]);
        }
        return byArray2;
    }

    protected KeyParameter generateRecordMACKey(StreamCipher streamCipher) {
        byte[] byArray = new byte[64];
        streamCipher.processBytes(byArray, 0, 64, byArray, 0);
        KeyParameter keyParameter = new KeyParameter(byArray, 0, 32);
        Arrays.fill(byArray, (byte)0);
        return keyParameter;
    }

    protected byte[] calculateRecordMAC(KeyParameter keyParameter, byte[] byArray, byte[] byArray2, int n2, int n3) {
        Poly1305 poly1305 = new Poly1305();
        poly1305.init(keyParameter);
        this.updateRecordMACText(poly1305, byArray, 0, byArray.length);
        this.updateRecordMACText(poly1305, byArray2, n2, n3);
        this.updateRecordMACLength(poly1305, byArray.length);
        this.updateRecordMACLength(poly1305, n3);
        byte[] byArray3 = new byte[poly1305.getMacSize()];
        poly1305.doFinal(byArray3, 0);
        return byArray3;
    }

    protected void updateRecordMACLength(Mac mac, int n2) {
        byte[] byArray = Pack.longToLittleEndian((long)n2 & 0xFFFFFFFFL);
        mac.update(byArray, 0, byArray.length);
    }

    protected void updateRecordMACText(Mac mac, byte[] byArray, int n2, int n3) {
        mac.update(byArray, n2, n3);
        int n4 = n3 % 16;
        if (n4 != 0) {
            mac.update(ZEROES, 0, 16 - n4);
        }
    }

    protected byte[] getAdditionalData(long l2, short s2, int n2) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l2, byArray, 0);
        TlsUtils.writeUint8(s2, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(n2, byArray, 11);
        return byArray;
    }
}

