/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.tls.DTLSRecordLayer;
import com.timevale.tgtext.bouncycastle.crypto.tls.DatagramTransport;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class DTLSTransport
implements DatagramTransport {
    private final DTLSRecordLayer recordLayer;

    DTLSTransport(DTLSRecordLayer dTLSRecordLayer) {
        this.recordLayer = dTLSRecordLayer;
    }

    @Override
    public int getReceiveLimit() throws IOException {
        return this.recordLayer.getReceiveLimit();
    }

    @Override
    public int getSendLimit() throws IOException {
        return this.recordLayer.getSendLimit();
    }

    @Override
    public int receive(byte[] byArray, int n2, int n3, int n4) throws IOException {
        try {
            return this.recordLayer.receive(byArray, n2, n3, n4);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.recordLayer.fail(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.recordLayer.fail((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    @Override
    public void send(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.recordLayer.send(byArray, n2, n3);
            return;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.recordLayer.fail(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.recordLayer.fail((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    @Override
    public void close() throws IOException {
        this.recordLayer.close();
    }
}

