/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.modes.AEADBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.params.AEADParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipher;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsAEADCipher
implements TlsCipher {
    public static final int NONCE_RFC5288 = 1;
    static final int NONCE_DRAFT_CHACHA20_POLY1305 = 2;
    protected TlsContext context;
    protected int macSize;
    protected int record_iv_length;
    protected AEADBlockCipher encryptCipher;
    protected AEADBlockCipher decryptCipher;
    protected byte[] encryptImplicitNonce;
    protected byte[] decryptImplicitNonce;
    protected int nonceMode;

    public TlsAEADCipher(TlsContext tlsContext, AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, int n2, int n3) throws IOException {
        this(tlsContext, aEADBlockCipher, aEADBlockCipher2, n2, n3, 1);
    }

    TlsAEADCipher(TlsContext tlsContext, AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, int n2, int n3, int n4) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        int n5;
        if (!TlsUtils.isTLSv12(tlsContext)) {
            throw new TlsFatalAlert(80);
        }
        this.nonceMode = n4;
        switch (n4) {
            case 1: {
                n5 = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                n5 = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.context = tlsContext;
        this.macSize = n3;
        int n6 = 2 * n2 + 2 * n5;
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n6);
        KeyParameter keyParameter3 = new KeyParameter(byArray, 0, n2);
        int n7 = n2 + 0;
        KeyParameter keyParameter4 = new KeyParameter(byArray, n7, n2);
        byte[] byArray2 = Arrays.copyOfRange(byArray, n7 += n2, n7 + n5);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n7 += n5, n7 + n5);
        if ((n7 += n5) != n6) {
            throw new TlsFatalAlert(80);
        }
        if (tlsContext.isServer()) {
            this.encryptCipher = aEADBlockCipher2;
            this.decryptCipher = aEADBlockCipher;
            this.encryptImplicitNonce = byArray3;
            this.decryptImplicitNonce = byArray2;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.encryptCipher = aEADBlockCipher;
            this.decryptCipher = aEADBlockCipher2;
            this.encryptImplicitNonce = byArray2;
            this.decryptImplicitNonce = byArray3;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        byte[] byArray4 = new byte[n5 + this.record_iv_length];
        this.encryptCipher.init(true, new AEADParameters(keyParameter2, n3 * 8, byArray4));
        this.decryptCipher.init(false, new AEADParameters(keyParameter, n3 * 8, byArray4));
    }

    @Override
    public int getPlaintextLimit(int n2) {
        return n2 - this.macSize - this.record_iv_length;
    }

    @Override
    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2 = new byte[this.encryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptImplicitNonce, 0, byArray2, 0, this.encryptImplicitNonce.length);
                TlsUtils.writeUint64(l2, byArray2, this.encryptImplicitNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(l2, byArray2, byArray2.length - 8);
                for (int i2 = 0; i2 < this.encryptImplicitNonce.length; ++i2) {
                    int n4 = i2;
                    byArray2[n4] = (byte)(byArray2[n4] ^ this.encryptImplicitNonce[i2]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        int n5 = this.encryptCipher.getOutputSize(n3);
        byte[] byArray3 = new byte[this.record_iv_length + n5];
        if (this.record_iv_length != 0) {
            System.arraycopy(byArray2, byArray2.length - this.record_iv_length, byArray3, 0, this.record_iv_length);
        }
        int n6 = this.record_iv_length;
        byte[] byArray4 = this.getAdditionalData(l2, s2, n3);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray2, byArray4);
        try {
            this.encryptCipher.init(true, aEADParameters);
            n6 += this.encryptCipher.processBytes(byArray, n2, n3, byArray3, n6);
            n6 += this.encryptCipher.doFinal(byArray3, n6);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
        if (n6 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    @Override
    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        if (this.getPlaintextLimit(n3) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray2 = new byte[this.decryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.decryptImplicitNonce, 0, byArray2, 0, this.decryptImplicitNonce.length);
                System.arraycopy(byArray, n2, byArray2, byArray2.length - this.record_iv_length, this.record_iv_length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(l2, byArray2, byArray2.length - 8);
                for (n5 = 0; n5 < this.decryptImplicitNonce.length; ++n5) {
                    int n6 = n5;
                    byArray2[n6] = (byte)(byArray2[n6] ^ this.decryptImplicitNonce[n5]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n5 = n2 + this.record_iv_length;
        int n7 = n3 - this.record_iv_length;
        int n8 = this.decryptCipher.getOutputSize(n7);
        byte[] byArray3 = new byte[n8];
        byte[] byArray4 = this.getAdditionalData(l2, s2, n8);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray2, byArray4);
        try {
            this.decryptCipher.init(false, aEADParameters);
            n4 = 0 + this.decryptCipher.processBytes(byArray, n5, n7, byArray3, 0);
            n4 += this.decryptCipher.doFinal(byArray3, n4);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(20, (Throwable)exception);
        }
        if (n4 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    protected byte[] getAdditionalData(long l2, short s2, int n2) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l2, byArray, 0);
        TlsUtils.writeUint8(s2, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(n2, byArray, 11);
        return byArray;
    }
}

