/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.tls.SessionParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSession;
import com.timevale.tgtext.bouncycastle.util.Arrays;

class TlsSessionImpl
implements TlsSession {
    final byte[] sessionID;
    SessionParameters sessionParameters;

    TlsSessionImpl(byte[] byArray, SessionParameters sessionParameters) {
        if (byArray == null) {
            throw new IllegalArgumentException("'sessionID' cannot be null");
        }
        if (byArray.length <= 0 || byArray.length > 32) {
            throw new IllegalArgumentException("'sessionID' must have length between 1 and 32 bytes, inclusive");
        }
        this.sessionID = Arrays.clone(byArray);
        this.sessionParameters = sessionParameters;
    }

    @Override
    public synchronized SessionParameters exportSessionParameters() {
        if (this.sessionParameters == null) {
            return null;
        }
        return this.sessionParameters.copy();
    }

    @Override
    public synchronized byte[] getSessionID() {
        return this.sessionID;
    }

    @Override
    public synchronized void invalidate() {
        if (this.sessionParameters != null) {
            this.sessionParameters.clear();
            this.sessionParameters = null;
        }
    }

    @Override
    public synchronized boolean isResumable() {
        return this.sessionParameters != null;
    }
}

