/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.est;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERPrintableString;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.est.CsrAttrs;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cmc.CMCException;
import com.timevale.tgtext.bouncycastle.cmc.SimplePKIResponse;
import com.timevale.tgtext.bouncycastle.est.CACertsResponse;
import com.timevale.tgtext.bouncycastle.est.CSRAttributesResponse;
import com.timevale.tgtext.bouncycastle.est.CSRRequestResponse;
import com.timevale.tgtext.bouncycastle.est.ESTAuth;
import com.timevale.tgtext.bouncycastle.est.ESTClient;
import com.timevale.tgtext.bouncycastle.est.ESTClientProvider;
import com.timevale.tgtext.bouncycastle.est.ESTException;
import com.timevale.tgtext.bouncycastle.est.ESTRequest;
import com.timevale.tgtext.bouncycastle.est.ESTRequestBuilder;
import com.timevale.tgtext.bouncycastle.est.ESTResponse;
import com.timevale.tgtext.bouncycastle.est.ESTSourceConnectionListener;
import com.timevale.tgtext.bouncycastle.est.EnrollmentResponse;
import com.timevale.tgtext.bouncycastle.est.Source;
import com.timevale.tgtext.bouncycastle.est.TLSUniqueProvider;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import com.timevale.tgtext.bouncycastle.util.Selector;
import com.timevale.tgtext.bouncycastle.util.Store;
import com.timevale.tgtext.bouncycastle.util.encoders.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class ESTService {
    protected static final String CACERTS = "/cacerts";
    protected static final String SIMPLE_ENROLL = "/simpleenroll";
    protected static final String SIMPLE_REENROLL = "/simplereenroll";
    protected static final String FULLCMC = "/fullcmc";
    protected static final String SERVERGEN = "/serverkeygen";
    protected static final String CSRATTRS = "/csrattrs";
    protected static final Set<String> illegalParts = new HashSet<String>();
    private final String server;
    private final ESTClientProvider clientProvider;
    private static final Pattern pathInvalid;

    ESTService(String string, String string2, ESTClientProvider eSTClientProvider) {
        string = this.verifyServer(string);
        if (string2 != null) {
            string2 = this.verifyLabel(string2);
            this.server = "https://" + string + "/.well-known/est/" + string2;
        } else {
            this.server = "https://" + string + "/.well-known/est";
        }
        this.clientProvider = eSTClientProvider;
    }

    public static X509CertificateHolder[] storeToArray(Store<X509CertificateHolder> store) {
        return ESTService.storeToArray(store, null);
    }

    public static X509CertificateHolder[] storeToArray(Store<X509CertificateHolder> store, Selector<X509CertificateHolder> selector) {
        Collection<X509CertificateHolder> collection = store.getMatches(selector);
        return collection.toArray(new X509CertificateHolder[collection.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public CACertsResponse getCACerts() throws Exception {
        var1_1 = null;
        var2_2 = null;
        try {
            var4_3 = new URL(this.server + "/cacerts");
            var5_4 = this.clientProvider.makeClient();
            var6_6 = new ESTRequestBuilder("GET", var4_3).withClient((ESTClient)var5_4).build();
            var1_1 = var5_4.doRequest(var6_6);
            var7_7 = null;
            var8_8 = null;
            if (var1_1.getStatusCode() == 200) {
                if (!"application/pkcs7-mime".equals(var1_1.getHeaders().getFirstValue("Content-Type"))) {
                    var9_9 = var1_1.getHeaders().getFirstValue("Content-Type") != null ? " got " + var1_1.getHeaders().getFirstValue("Content-Type") : " but was not present.";
                    throw new ESTException("Response : " + var4_3.toString() + "Expecting application/pkcs7-mime " + var9_9, null, var1_1.getStatusCode(), var1_1.getInputStream());
                }
                try {
                    if (var1_1.getContentLength() == null || var1_1.getContentLength() <= 0L) ** GOTO lbl25
                    var9_10 = new ASN1InputStream(var1_1.getInputStream());
                    var10_12 = new SimplePKIResponse(ContentInfo.getInstance((ASN1Sequence)var9_10.readObject()));
                    var7_7 = var10_12.getCertificates();
                    var8_8 = var10_12.getCRLs();
                }
                catch (Throwable var9_11) {
                    throw new ESTException("Decoding CACerts: " + var4_3.toString() + " " + var9_11.getMessage(), var9_11, var1_1.getStatusCode(), var1_1.getInputStream());
                }
            } else if (var1_1.getStatusCode() != 204) {
                throw new ESTException("Get CACerts: " + var4_3.toString(), null, var1_1.getStatusCode(), var1_1.getInputStream());
            }
lbl25:
            // 4 sources

            var3_13 = new CACertsResponse(var7_7, var8_8, var6_6, var1_1.getSource(), this.clientProvider.isTrusted());
            ** if (var1_1 == null) goto lbl-1000
        }
        catch (Throwable v1) {
            try {
                var5_5 = v1;
                if (v1 instanceof ESTException) {
                    throw (ESTException)var5_5;
                }
                throw new ESTException(var5_5.getMessage(), var5_5);
            }
            catch (Throwable var11_14) {
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (Exception v2) {}
                }
                throw var11_14;
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                var1_1.close();
            }
            catch (Exception v0) {
                var5_4 = v0;
                var2_2 = v0;
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var2_2 != null) {
            if (var2_2 instanceof ESTException) {
                throw var2_2;
            }
            throw new ESTException("Get CACerts: " + var4_3.toString(), (Throwable)var2_2, var1_1.getStatusCode(), null);
        }
        return var3_13;
    }

    public EnrollmentResponse simpleEnroll(EnrollmentResponse enrollmentResponse) throws Exception {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse eSTResponse = null;
        try {
            ESTClient eSTClient = this.clientProvider.makeClient();
            eSTResponse = eSTClient.doRequest(new ESTRequestBuilder(enrollmentResponse.getRequestToRetry()).withClient(eSTClient).build());
            EnrollmentResponse enrollmentResponse2 = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof ESTException) {
                throw (ESTException)throwable2;
            }
            throw new ESTException(throwable2.getMessage(), throwable2);
        }
        finally {
            if (eSTResponse != null) {
                eSTResponse.close();
            }
        }
    }

    public EnrollmentResponse simpleEnroll(boolean bl2, PKCS10CertificationRequest pKCS10CertificationRequest, ESTAuth eSTAuth) throws IOException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse eSTResponse = null;
        try {
            byte[] byArray = this.annotateRequest(pKCS10CertificationRequest.getEncoded()).getBytes();
            URL uRL = new URL(this.server + (bl2 ? SIMPLE_REENROLL : SIMPLE_ENROLL));
            ESTClient eSTClient = this.clientProvider.makeClient();
            ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder("POST", uRL).withData(byArray).withClient(eSTClient);
            eSTRequestBuilder.addHeader("Content-Type", "application/pkcs10");
            eSTRequestBuilder.addHeader("Content-Length", "" + byArray.length);
            eSTRequestBuilder.addHeader("Content-Transfer-Encoding", "base64");
            if (eSTAuth != null) {
                eSTAuth.applyAuth(eSTRequestBuilder);
            }
            eSTResponse = eSTClient.doRequest(eSTRequestBuilder.build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof ESTException) {
                throw (ESTException)throwable2;
            }
            throw new ESTException(throwable2.getMessage(), throwable2);
        }
        finally {
            if (eSTResponse != null) {
                eSTResponse.close();
            }
        }
    }

    public EnrollmentResponse simpleEnrollPoP(boolean bl2, final PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder, final ContentSigner contentSigner, ESTAuth eSTAuth) throws IOException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse eSTResponse = null;
        try {
            URL uRL = new URL(this.server + (bl2 ? SIMPLE_REENROLL : SIMPLE_ENROLL));
            ESTClient eSTClient = this.clientProvider.makeClient();
            ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder("POST", uRL).withClient(eSTClient).withConnectionListener(new ESTSourceConnectionListener(){

                public ESTRequest onConnection(Source source, ESTRequest eSTRequest) throws IOException {
                    if (source instanceof TLSUniqueProvider && ((TLSUniqueProvider)((Object)source)).isTLSUniqueAvailable()) {
                        PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder2 = new PKCS10CertificationRequestBuilder(pKCS10CertificationRequestBuilder);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = ((TLSUniqueProvider)((Object)source)).getTLSUnique();
                        pKCS10CertificationRequestBuilder2.setAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, new DERPrintableString(Base64.toBase64String(byArray)));
                        byteArrayOutputStream.write(ESTService.this.annotateRequest(pKCS10CertificationRequestBuilder2.build(contentSigner).getEncoded()).getBytes());
                        byteArrayOutputStream.flush();
                        ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder(eSTRequest).withData(byteArrayOutputStream.toByteArray());
                        eSTRequestBuilder.setHeader("Content-Type", "application/pkcs10");
                        eSTRequestBuilder.setHeader("Content-Transfer-Encoding", "base64");
                        eSTRequestBuilder.setHeader("Content-Length", Long.toString(byteArrayOutputStream.size()));
                        return eSTRequestBuilder.build();
                    }
                    throw new IOException("Source does not supply TLS unique.");
                }
            });
            if (eSTAuth != null) {
                eSTAuth.applyAuth(eSTRequestBuilder);
            }
            eSTResponse = eSTClient.doRequest(eSTRequestBuilder.build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof ESTException) {
                throw (ESTException)throwable2;
            }
            throw new ESTException(throwable2.getMessage(), throwable2);
        }
        finally {
            if (eSTResponse != null) {
                eSTResponse.close();
            }
        }
    }

    protected EnrollmentResponse handleEnrollResponse(ESTResponse eSTResponse) throws IOException {
        ESTRequest eSTRequest = eSTResponse.getOriginalRequest();
        if (eSTResponse.getStatusCode() == 202) {
            long l2;
            String string = eSTResponse.getHeader("Retry-After");
            if (string == null) {
                throw new ESTException("Got Status 202 but not Retry-After header from: " + eSTRequest.getURL().toString());
            }
            try {
                l2 = System.currentTimeMillis() + Long.parseLong(string) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    l2 = simpleDateFormat.parse(string).getTime();
                }
                catch (Exception exception) {
                    throw new ESTException("Unable to parse Retry-After header:" + eSTRequest.getURL().toString() + " " + exception.getMessage(), null, eSTResponse.getStatusCode(), eSTResponse.getInputStream());
                }
            }
            return new EnrollmentResponse(null, l2, eSTRequest, eSTResponse.getSource());
        }
        if (eSTResponse.getStatusCode() == 200) {
            SimplePKIResponse simplePKIResponse;
            ASN1InputStream aSN1InputStream = new ASN1InputStream(eSTResponse.getInputStream());
            try {
                simplePKIResponse = new SimplePKIResponse(ContentInfo.getInstance(aSN1InputStream.readObject()));
            }
            catch (CMCException cMCException) {
                throw new ESTException(cMCException.getMessage(), cMCException.getCause());
            }
            Store<X509CertificateHolder> store = simplePKIResponse.getCertificates();
            return new EnrollmentResponse(store, -1L, null, eSTResponse.getSource());
        }
        throw new ESTException("Simple Enroll: " + eSTRequest.getURL().toString(), null, eSTResponse.getStatusCode(), eSTResponse.getInputStream());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CSRRequestResponse getCSRAttributes() throws ESTException {
        Exception exception;
        CSRAttributesResponse cSRAttributesResponse;
        ESTResponse eSTResponse;
        block16: {
            Object object;
            if (!this.clientProvider.isTrusted()) {
                throw new IllegalStateException("No trust anchors.");
            }
            eSTResponse = null;
            cSRAttributesResponse = null;
            exception = null;
            try {
                URL uRL = new URL(this.server + CSRATTRS);
                object = this.clientProvider.makeClient();
                ESTRequest eSTRequest = new ESTRequestBuilder("GET", uRL).withClient((ESTClient)object).build();
                eSTResponse = object.doRequest(eSTRequest);
                switch (eSTResponse.getStatusCode()) {
                    case 200: {
                        try {
                            if (eSTResponse.getContentLength() == null || eSTResponse.getContentLength() <= 0L) break;
                            ASN1InputStream aSN1InputStream = new ASN1InputStream(eSTResponse.getInputStream());
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                            cSRAttributesResponse = new CSRAttributesResponse(CsrAttrs.getInstance(aSN1Sequence));
                            break;
                        }
                        catch (Throwable throwable) {
                            throw new ESTException("Decoding CACerts: " + uRL.toString() + " " + throwable.getMessage(), throwable, eSTResponse.getStatusCode(), eSTResponse.getInputStream());
                        }
                    }
                    case 204: {
                        cSRAttributesResponse = null;
                        break;
                    }
                    case 404: {
                        cSRAttributesResponse = null;
                        break;
                    }
                    default: {
                        throw new ESTException("CSR Attribute request: " + eSTRequest.getURL().toString(), null, eSTResponse.getStatusCode(), eSTResponse.getInputStream());
                    }
                }
                if (eSTResponse == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    if (!(throwable instanceof ESTException)) throw new ESTException(throwable2.getMessage(), throwable2);
                    throw (ESTException)throwable2;
                }
                catch (Throwable throwable3) {
                    if (eSTResponse == null) throw throwable3;
                    try {
                        eSTResponse.close();
                        throw throwable3;
                    }
                    catch (Exception exception2) {}
                    throw throwable3;
                }
            }
            try {
                eSTResponse.close();
            }
            catch (Exception exception3) {
                object = exception3;
                exception = exception3;
            }
        }
        if (exception == null) return new CSRRequestResponse(cSRAttributesResponse, eSTResponse.getSource());
        if (!(exception instanceof ESTException)) throw new ESTException(exception.getMessage(), (Throwable)exception, eSTResponse.getStatusCode(), null);
        throw (ESTException)exception;
    }

    private String annotateRequest(byte[] byArray) {
        int n2 = 0;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        do {
            if (n2 + 48 < byArray.length) {
                printWriter.print(Base64.toBase64String(byArray, n2, 48));
                n2 += 48;
            } else {
                printWriter.print(Base64.toBase64String(byArray, n2, byArray.length - n2));
                n2 = byArray.length;
            }
            printWriter.print('\n');
        } while (n2 < byArray.length);
        printWriter.flush();
        return stringWriter.toString();
    }

    private String verifyLabel(String string) {
        while (string.endsWith("/") && string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        while (string.startsWith("/") && string.length() > 0) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Label set but after trimming '/' is not zero length string.");
        }
        if (!pathInvalid.matcher(string).matches()) {
            throw new IllegalArgumentException("Server path " + string + " contains invalid characters");
        }
        if (illegalParts.contains(string)) {
            throw new IllegalArgumentException("Label " + string + " is a reserved path segment.");
        }
        return string;
    }

    private String verifyServer(String string) {
        try {
            while (string.endsWith("/") && string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.contains("://")) {
                throw new IllegalArgumentException("Server contains scheme, must only be <dnsname/ipaddress>:port, https:// will be added arbitrarily.");
            }
            URL uRL = new URL("https://" + string);
            if (uRL.getPath().length() == 0 || uRL.getPath().equals("/")) {
                return string;
            }
            throw new IllegalArgumentException("Server contains path, must only be <dnsname/ipaddress>:port, a path of '/.well-known/est/<label>' will be added arbitrarily.");
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)exception2;
            }
            throw new IllegalArgumentException("Scheme and host is invalid: " + exception2.getMessage(), exception2);
        }
    }

    static {
        illegalParts.add(CACERTS.substring(1));
        illegalParts.add(SIMPLE_ENROLL.substring(1));
        illegalParts.add(SIMPLE_REENROLL.substring(1));
        illegalParts.add(FULLCMC.substring(1));
        illegalParts.add(SERVERGEN.substring(1));
        illegalParts.add(CSRATTRS.substring(1));
        pathInvalid = Pattern.compile("^[0-9a-zA-Z_\\-.~!$&'()*+,;=]+");
    }
}

