/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.Wrapper;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithSBox;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithUKM;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.timevale.tgtext.bouncycastle.jcajce.spec.GOST28147WrapParameterSpec;
import com.timevale.tgtext.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.util.JcaJceHelper;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseWrapCipher
extends CipherSpi
implements PBE {
    private Class[] availableSpecs = new Class[]{GOST28147WrapParameterSpec.class, PBEParameterSpec.class, RC2ParameterSpec.class, RC5ParameterSpec.class, IvParameterSpec.class};
    protected int pbeType = 2;
    protected int pbeHash = 1;
    protected int pbeKeySize;
    protected int pbeIvSize;
    protected AlgorithmParameters engineParams = null;
    protected Wrapper wrapEngine = null;
    private int ivSize;
    private byte[] iv;
    private final JcaJceHelper helper = new BCJcaJceHelper();

    protected BaseWrapCipher() {
    }

    protected BaseWrapCipher(Wrapper wrapper) {
        this(wrapper, 0);
    }

    protected BaseWrapCipher(Wrapper wrapper, int n2) {
        this.wrapEngine = wrapper;
        this.ivSize = n2;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return Arrays.clone(this.iv);
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length << 3;
    }

    @Override
    protected int engineGetOutputSize(int n2) {
        return -1;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected final AlgorithmParameters createParametersInstance(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.helper.createAlgorithmParameters(string);
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("can't support mode " + string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + string + " unknown.");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        void var5_15;
        Object object;
        if (key instanceof BCPBEKey) {
            object = (BCPBEKey)key;
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                CipherParameters cipherParameters = PBE.Util.makePBEParameters((BCPBEKey)object, algorithmParameterSpec, this.wrapEngine.getAlgorithmName());
            } else {
                if (((BCPBEKey)object).getParam() == null) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                CipherParameters cipherParameters = ((BCPBEKey)object).getParam();
            }
        } else {
            KeyParameter keyParameter = new KeyParameter(key.getEncoded());
        }
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            void var5_9;
            object = (IvParameterSpec)algorithmParameterSpec;
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)var5_9, ((IvParameterSpec)object).getIV());
        }
        if (algorithmParameterSpec instanceof GOST28147WrapParameterSpec) {
            void var5_13;
            object = (GOST28147WrapParameterSpec)algorithmParameterSpec;
            byte[] byArray = ((GOST28147WrapParameterSpec)object).getSBox();
            if (byArray != null) {
                void var5_11;
                ParametersWithSBox parametersWithSBox = new ParametersWithSBox((CipherParameters)var5_11, byArray);
            }
            ParametersWithUKM parametersWithUKM = new ParametersWithUKM((CipherParameters)var5_13, ((GOST28147WrapParameterSpec)object).getUKM());
        }
        if (var5_15 instanceof KeyParameter && this.ivSize != 0) {
            this.iv = new byte[this.ivSize];
            secureRandom.nextBytes(this.iv);
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)var5_15, this.iv);
        }
        if (secureRandom != null) {
            void var5_17;
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_17, secureRandom);
        }
        switch (n2) {
            case 3: {
                void var5_19;
                this.wrapEngine.init(true, (CipherParameters)var5_19);
                return;
            }
            case 4: {
                void var5_19;
                this.wrapEngine.init(false, (CipherParameters)var5_19);
                return;
            }
            case 1: 
            case 2: {
                throw new IllegalArgumentException("engine only valid for wrapping");
            }
        }
        System.out.println("eeek!");
    }

    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i2 = 0; i2 != this.availableSpecs.length; ++i2) {
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.availableSpecs[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineParams = algorithmParameters;
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        throw new RuntimeException("not supported for wrapping");
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        throw new RuntimeException("not supported for wrapping");
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        return null;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        return 0;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            if (this.wrapEngine == null) {
                return this.engineDoFinal(byArray, 0, byArray.length);
            }
            return this.wrapEngine.wrap(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException(badPaddingException.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.wrapEngine == null ? this.engineDoFinal(byArray, 0, byArray.length) : this.wrapEngine.unwrap(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidKeyException(invalidCipherTextException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        if (n2 == 3) {
            return new SecretKeySpec(byArray2, string);
        }
        if (string.equals("") && n2 == 2) {
            try {
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(byArray2);
                PrivateKey privateKey = BouncyCastleProvider.getPrivateKey(privateKeyInfo);
                if (privateKey != null) {
                    return privateKey;
                }
                throw new InvalidKeyException("algorithm " + privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm() + " not supported");
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Invalid key encoding.");
            }
        }
        try {
            KeyFactory keyFactory = this.helper.createKeyFactory(string);
            if (n2 == 1) {
                return keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            }
            if (n2 == 2) {
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InvalidKeyException("Unknown key type " + noSuchProviderException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Unknown key type " + invalidKeySpecException.getMessage());
        }
        throw new InvalidKeyException("Unknown key type " + n2);
    }
}

