/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import com.timevale.tgtext.bouncycastle.jce.spec.ECParameterSpec;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.DHParameterSpec;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission("BC", "ecImplicitlyCa");
    private static Permission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalDhDefaultParams");
    private static Permission BC_DH_PERMISSION = new ProviderConfigurationPermission("BC", "DhDefaultParams");
    private static Permission BC_EC_CURVE_PERMISSION = new ProviderConfigurationPermission("BC", "acceptableEcCurves");
    private static Permission BC_ADDITIONAL_EC_CURVE_PERMISSION = new ProviderConfigurationPermission("BC", "additionalEcParameters");
    private ThreadLocal ecThreadSpec = new ThreadLocal();
    private ThreadLocal dhThreadSpec = new ThreadLocal();
    private volatile ECParameterSpec ecImplicitCaParams;
    private volatile Object dhDefaultParams;
    private volatile Set acceptableNamedCurves = new HashSet();
    private volatile Map additionalECParameters = new HashMap();

    BouncyCastleProviderConfiguration() {
    }

    /*
     * Enabled aggressive block sorting
     */
    void setParameter(String string, Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (string.equals("threadLocalEcImplicitlyCa")) {
            ECParameterSpec eCParameterSpec;
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if ((eCParameterSpec = object instanceof ECParameterSpec || object == null ? (ECParameterSpec)object : EC5Util.convertSpec((java.security.spec.ECParameterSpec)object, false)) == null) {
                this.ecThreadSpec.remove();
                return;
            }
            this.ecThreadSpec.set(eCParameterSpec);
            return;
        }
        if (string.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            if (!(object instanceof ECParameterSpec) && object != null) {
                this.ecImplicitCaParams = EC5Util.convertSpec((java.security.spec.ECParameterSpec)object, false);
                return;
            }
            this.ecImplicitCaParams = (ECParameterSpec)object;
            return;
        }
        if (string.equals("threadLocalDhDefaultParams")) {
            Object object2;
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(object instanceof DHParameterSpec) && !(object instanceof DHParameterSpec[])) {
                if (object != null) throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            if ((object2 = object) == null) {
                this.dhThreadSpec.remove();
                return;
            }
            this.dhThreadSpec.set(object2);
            return;
        }
        if (string.equals("DhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (!(object instanceof DHParameterSpec) && !(object instanceof DHParameterSpec[])) {
                if (object != null) throw new IllegalArgumentException("not a valid DHParameterSpec or DHParameterSpec[]");
            }
            this.dhDefaultParams = object;
            return;
        }
        if (string.equals("acceptableEcCurves")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_CURVE_PERMISSION);
            }
            this.acceptableNamedCurves = (Set)object;
            return;
        }
        if (!string.equals("additionalEcParameters")) return;
        if (securityManager != null) {
            securityManager.checkPermission(BC_ADDITIONAL_EC_CURVE_PERMISSION);
        }
        this.additionalECParameters = (Map)object;
    }

    @Override
    public ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecThreadSpec.get();
        if (eCParameterSpec != null) {
            return eCParameterSpec;
        }
        return this.ecImplicitCaParams;
    }

    @Override
    public DHParameterSpec getDHDefaultParameters(int n2) {
        Object object = this.dhThreadSpec.get();
        if (object == null) {
            object = this.dhDefaultParams;
        }
        if (object instanceof DHParameterSpec) {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)object;
            if (dHParameterSpec.getP().bitLength() == n2) {
                return dHParameterSpec;
            }
        } else if (object instanceof DHParameterSpec[]) {
            DHParameterSpec[] dHParameterSpecArray = (DHParameterSpec[])object;
            for (int i2 = 0; i2 != dHParameterSpecArray.length; ++i2) {
                if (dHParameterSpecArray[i2].getP().bitLength() != n2) continue;
                return dHParameterSpecArray[i2];
            }
        }
        return null;
    }

    @Override
    public Set getAcceptableNamedCurves() {
        return Collections.unmodifiableSet(this.acceptableNamedCurves);
    }

    @Override
    public Map getAdditionalECParameters() {
        return Collections.unmodifiableMap(this.additionalECParameters);
    }
}

