/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ec;

import com.timevale.tgtext.bouncycastle.math.ec.AbstractECMultiplier;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import com.timevale.tgtext.bouncycastle.math.ec.LongArray;
import com.timevale.tgtext.bouncycastle.math.ec.WNafPreCompInfo;
import com.timevale.tgtext.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;

public class WNafL2RMultiplier
extends AbstractECMultiplier {
    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        int n2 = Math.max(2, Math.min(16, this.getWindowSize(bigInteger.bitLength())));
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n2, true);
        ECPoint[] eCPointArray = wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray2 = wNafPreCompInfo.getPreCompNeg();
        int[] nArray = WNafUtil.generateCompactWindowNaf(n2, bigInteger);
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        boolean bl2 = true;
        while (true) {
            ECPoint[] eCPointArray3;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            block6: {
                block5: {
                    if (!bl2 || (bl2 = false)) break block5;
                    n7 = nArray.length;
                    if (n7 <= 1) break block6;
                    n6 = nArray[--n7];
                    n5 = n6 >> 16;
                    n4 = n6 & 0xFFFF;
                    n3 = Math.abs(n5);
                    ECPoint[] eCPointArray4 = eCPointArray3 = n5 < 0 ? eCPointArray2 : eCPointArray;
                    if (n3 << 2 < 1 << n2) {
                        byte by2 = LongArray.bitLengths[n3];
                        int n8 = n2 - by2;
                        int n9 = n3 ^ 1 << by2 - 1;
                        int n10 = (1 << n2 - 1) - 1;
                        int n11 = (n9 << n8) + 1;
                        eCPoint2 = eCPointArray3[n10 >>> 1].add(eCPointArray3[n11 >>> 1]);
                        n4 -= n8;
                    } else {
                        eCPoint2 = eCPointArray3[n3 >>> 1];
                    }
                }
                eCPoint2 = eCPoint2.timesPow2(n4);
            }
            if (n7 <= 0) {
                return eCPoint2;
            }
            n6 = nArray[--n7];
            n5 = n6 >> 16;
            n4 = n6 & 0xFFFF;
            n3 = Math.abs(n5);
            eCPointArray3 = n5 < 0 ? eCPointArray2 : eCPointArray;
            ECPoint eCPoint3 = eCPointArray3[n3 >>> 1];
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
    }

    protected int getWindowSize(int n2) {
        return WNafUtil.getWindowSize(n2);
    }
}

