/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ec.custom.sec;

import com.timevale.tgtext.bouncycastle.math.ec.ECFieldElement;
import com.timevale.tgtext.bouncycastle.math.ec.custom.sec.SecP192R1Curve;
import com.timevale.tgtext.bouncycastle.math.ec.custom.sec.SecP192R1Field;
import com.timevale.tgtext.bouncycastle.math.raw.Mod;
import com.timevale.tgtext.bouncycastle.math.raw.Nat192;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecP192R1FieldElement
extends ECFieldElement {
    public static final BigInteger Q = SecP192R1Curve.q;
    protected int[] x;

    public SecP192R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP192R1FieldElement");
        }
        this.x = SecP192R1Field.fromBigInteger(bigInteger);
    }

    public SecP192R1FieldElement() {
        this.x = Nat192.create();
    }

    protected SecP192R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat192.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat192.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat192.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat192.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP192R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192R1Field.add(this.x, ((SecP192R1FieldElement)eCFieldElement).x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat192.create();
        SecP192R1Field.addOne(this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192R1Field.subtract(this.x, ((SecP192R1FieldElement)eCFieldElement).x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192R1Field.multiply(this.x, ((SecP192R1FieldElement)eCFieldElement).x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        Mod.invert(SecP192R1Field.P, ((SecP192R1FieldElement)eCFieldElement).x, nArray);
        SecP192R1Field.multiply(nArray, this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat192.create();
        SecP192R1Field.negate(this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat192.create();
        SecP192R1Field.square(this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat192.create();
        Mod.invert(SecP192R1Field.P, this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat192.isZero(this.x) || Nat192.isOne(nArray)) {
            return this;
        }
        int[] nArray2 = Nat192.create();
        int[] nArray3 = Nat192.create();
        SecP192R1Field.square(nArray, nArray2);
        SecP192R1Field.multiply(nArray2, nArray, nArray2);
        SecP192R1Field.squareN(nArray2, 2, nArray3);
        SecP192R1Field.multiply(nArray3, nArray2, nArray3);
        SecP192R1Field.squareN(nArray3, 4, nArray2);
        SecP192R1Field.multiply(nArray2, nArray3, nArray2);
        SecP192R1Field.squareN(nArray2, 8, nArray3);
        SecP192R1Field.multiply(nArray3, nArray2, nArray3);
        SecP192R1Field.squareN(nArray3, 16, nArray2);
        SecP192R1Field.multiply(nArray2, nArray3, nArray2);
        SecP192R1Field.squareN(nArray2, 32, nArray3);
        SecP192R1Field.multiply(nArray3, nArray2, nArray3);
        SecP192R1Field.squareN(nArray3, 64, nArray2);
        SecP192R1Field.multiply(nArray2, nArray3, nArray2);
        SecP192R1Field.squareN(nArray2, 62, nArray2);
        SecP192R1Field.square(nArray2, nArray3);
        if (Nat192.eq(nArray, nArray3)) {
            return new SecP192R1FieldElement(nArray2);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP192R1FieldElement)) {
            return false;
        }
        SecP192R1FieldElement secP192R1FieldElement = (SecP192R1FieldElement)object;
        return Nat192.eq(this.x, secP192R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 6);
    }
}

