/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl;

import com.timevale.tgtext.bouncycastle.openssl.PEMDecryptor;
import com.timevale.tgtext.bouncycastle.openssl.PEMDecryptorProvider;
import com.timevale.tgtext.bouncycastle.openssl.PEMException;
import com.timevale.tgtext.bouncycastle.openssl.PEMKeyPair;
import com.timevale.tgtext.bouncycastle.openssl.PEMKeyPairParser;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import java.io.IOException;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String string, byte[] byArray, byte[] byArray2, PEMKeyPairParser pEMKeyPairParser) {
        this.dekAlgName = string;
        this.iv = byArray;
        this.keyBytes = byArray2;
        this.parser = pEMKeyPairParser;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider pEMDecryptorProvider) throws IOException {
        try {
            PEMDecryptor pEMDecryptor = pEMDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(pEMDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new PEMException("cannot create extraction operator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        catch (Exception exception) {
            throw new PEMException("exception processing key pair: " + exception.getMessage(), exception);
        }
    }
}

