/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.xmss;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSUtil;

public final class XMSSMTPublicKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSMTParameters params;
    private final byte[] root;
    private final byte[] publicSeed;

    private XMSSMTPublicKeyParameters(Builder builder) {
        super(false);
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.params.getDigestSize();
        byte[] byArray = builder.publicKey;
        if (byArray != null) {
            int n3 = n2 + n2;
            if (byArray.length != n3) {
                throw new IllegalArgumentException("public key has wrong size");
            }
            this.root = XMSSUtil.extractBytesAtOffset(byArray, 0, n2);
            int n4 = n2 + 0;
            this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n4, n2);
            return;
        }
        byte[] byArray2 = builder.root;
        if (byArray2 != null) {
            if (byArray2.length != n2) {
                throw new IllegalArgumentException("length of root must be equal to length of digest");
            }
            this.root = byArray2;
        } else {
            this.root = new byte[n2];
        }
        byte[] byArray3 = builder.publicSeed;
        if (byArray3 != null) {
            if (byArray3.length != n2) {
                throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
            }
            this.publicSeed = byArray3;
            return;
        }
        this.publicSeed = new byte[n2];
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.params.getDigestSize();
        int n3 = n2 + n2;
        byte[] byArray = new byte[n3];
        XMSSUtil.copyBytesAtOffset(byArray, this.root, 0);
        int n4 = n2 + 0;
        XMSSUtil.copyBytesAtOffset(byArray, this.publicSeed, n4);
        return byArray;
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public XMSSMTParameters getParameters() {
        return this.params;
    }

    public static class Builder {
        private final XMSSMTParameters params;
        private byte[] root = null;
        private byte[] publicSeed = null;
        private byte[] publicKey = null;

        public Builder(XMSSMTParameters xMSSMTParameters) {
            this.params = xMSSMTParameters;
        }

        public Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicKey(byte[] byArray) {
            this.publicKey = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public XMSSMTPublicKeyParameters build() {
            return new XMSSMTPublicKeyParameters(this);
        }
    }
}

