/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.xmss;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.BDS;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Pack;
import java.io.IOException;

public final class XMSSPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSParameters params;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final BDS bdsState;

    private XMSSPrivateKeyParameters(Builder builder) {
        super(true);
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.params.getDigestSize();
        byte[] byArray = builder.privateKey;
        if (byArray != null) {
            int n3;
            if (builder.xmss == null) {
                throw new NullPointerException("xmss == null");
            }
            int n4 = this.params.getHeight();
            if (!XMSSUtil.isIndexValid(n4, n3 = Pack.bigEndianToInt(byArray, 0))) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(byArray, 4, n2);
            int n5 = n2 + 4;
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(byArray, n5, n2);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n5 += n2, n2);
            this.root = XMSSUtil.extractBytesAtOffset(byArray, n5 += n2, n2);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n5 += n2, byArray.length - n5);
            BDS bDS = null;
            try {
                bDS = (BDS)XMSSUtil.deserialize(byArray2);
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                classNotFoundException.printStackTrace();
            }
            bDS.setXMSS(builder.xmss);
            bDS.validate();
            if (bDS.getIndex() != n3) {
                throw new IllegalStateException("serialized BDS has wrong index");
            }
            this.bdsState = bDS;
            return;
        }
        byte[] byArray3 = builder.secretKeySeed;
        if (byArray3 != null) {
            if (byArray3.length != n2) {
                throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
            }
            this.secretKeySeed = byArray3;
        } else {
            this.secretKeySeed = new byte[n2];
        }
        byte[] byArray4 = builder.secretKeyPRF;
        if (byArray4 != null) {
            if (byArray4.length != n2) {
                throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
            }
            this.secretKeyPRF = byArray4;
        } else {
            this.secretKeyPRF = new byte[n2];
        }
        byte[] byArray5 = builder.publicSeed;
        if (byArray5 != null) {
            if (byArray5.length != n2) {
                throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
            }
            this.publicSeed = byArray5;
        } else {
            this.publicSeed = new byte[n2];
        }
        byte[] byArray6 = builder.root;
        if (byArray6 != null) {
            if (byArray6.length != n2) {
                throw new IllegalArgumentException("size of root needs to be equal size of digest");
            }
            this.root = byArray6;
        } else {
            this.root = new byte[n2];
        }
        BDS bDS = builder.bdsState;
        if (bDS != null) {
            this.bdsState = bDS;
            return;
        }
        if (builder.index < (1 << this.params.getHeight()) - 2 && byArray5 != null && byArray3 != null) {
            this.bdsState = new BDS(this.params, byArray5, byArray3, (OTSHashAddress)new OTSHashAddress.Builder().build(), builder.index);
            return;
        }
        this.bdsState = new BDS(this.params, builder.index);
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray;
        int n2 = this.params.getDigestSize();
        int n3 = n2 + 4 + n2 + n2 + n2;
        byte[] byArray2 = new byte[n3];
        Pack.intToBigEndian(this.bdsState.getIndex(), byArray2, 0);
        XMSSUtil.copyBytesAtOffset(byArray2, this.secretKeySeed, 4);
        int n4 = n2 + 4;
        XMSSUtil.copyBytesAtOffset(byArray2, this.secretKeyPRF, n4);
        XMSSUtil.copyBytesAtOffset(byArray2, this.publicSeed, n4 += n2);
        XMSSUtil.copyBytesAtOffset(byArray2, this.root, n4 += n2);
        try {
            byArray = XMSSUtil.serialize(this.bdsState);
        }
        catch (IOException iOException) {
            throw new RuntimeException("error serializing bds state: " + iOException.getMessage());
        }
        return Arrays.concatenate(byArray2, byArray);
    }

    public int getIndex() {
        return this.bdsState.getIndex();
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    BDS getBDSState() {
        return this.bdsState;
    }

    public XMSSParameters getParameters() {
        return this.params;
    }

    public XMSSPrivateKeyParameters getNextKey() {
        int n2 = this.params.getHeight();
        if (this.getIndex() < (1 << n2) - 1) {
            return new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withBDSState(this.bdsState.getNextState(this.publicSeed, this.secretKeySeed, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        }
        return new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withBDSState(new BDS(this.params, this.getIndex() + 1)).build();
    }

    public static class Builder {
        private final XMSSParameters params;
        private int index = 0;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private BDS bdsState = null;
        private byte[] privateKey = null;
        private XMSSParameters xmss = null;

        public Builder(XMSSParameters xMSSParameters) {
            this.params = xMSSParameters;
        }

        public Builder withIndex(int n2) {
            this.index = n2;
            return this;
        }

        public Builder withSecretKeySeed(byte[] byArray) {
            this.secretKeySeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] byArray) {
            this.secretKeyPRF = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withBDSState(BDS bDS) {
            this.bdsState = bDS;
            return this;
        }

        public Builder withPrivateKey(byte[] byArray, XMSSParameters xMSSParameters) {
            this.privateKey = XMSSUtil.cloneArray(byArray);
            this.xmss = xMSSParameters;
            return this;
        }

        public XMSSPrivateKeyParameters build() {
            return new XMSSPrivateKeyParameters(this);
        }
    }
}

