/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.xmss;

import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.timevale.tgtext.bouncycastle.util.Pack;

public final class XMSSSignature
extends XMSSReducedSignature
implements XMSSStoreableObjectInterface {
    private final int index;
    private final byte[] random;

    private XMSSSignature(Builder builder) {
        super(builder);
        this.index = builder.index;
        int n2 = this.getParams().getDigestSize();
        byte[] byArray = builder.random;
        if (byArray != null) {
            if (byArray.length != n2) {
                throw new IllegalArgumentException("size of random needs to be equal to size of digest");
            }
            this.random = byArray;
            return;
        }
        this.random = new byte[n2];
    }

    @Override
    public byte[] toByteArray() {
        int n2;
        int n3 = this.getParams().getDigestSize();
        int n4 = this.getParams().getWOTSPlus().getParams().getLen() * n3;
        int n5 = this.getParams().getHeight() * n3;
        int n6 = n3 + 4 + n4 + n5;
        byte[] byArray = new byte[n6];
        Pack.intToBigEndian(this.index, byArray, 0);
        XMSSUtil.copyBytesAtOffset(byArray, this.random, 4);
        int n7 = n3 + 4;
        byte[][] byArray2 = this.getWOTSPlusSignature().toByteArray();
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            XMSSUtil.copyBytesAtOffset(byArray, byArray2[n2], n7);
            n7 += n3;
        }
        for (n2 = 0; n2 < this.getAuthPath().size(); ++n2) {
            byte[] byArray3 = this.getAuthPath().get(n2).getValue();
            XMSSUtil.copyBytesAtOffset(byArray, byArray3, n7);
            n7 += n3;
        }
        return byArray;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getRandom() {
        return XMSSUtil.cloneArray(this.random);
    }

    public static class Builder
    extends XMSSReducedSignature.Builder {
        private final XMSSParameters params;
        private int index = 0;
        private byte[] random = null;

        public Builder(XMSSParameters xMSSParameters) {
            super(xMSSParameters);
            this.params = xMSSParameters;
        }

        public Builder withIndex(int n2) {
            this.index = n2;
            return this;
        }

        public Builder withRandom(byte[] byArray) {
            this.random = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSignature(byte[] byArray) {
            if (byArray == null) {
                throw new NullPointerException("signature == null");
            }
            int n2 = this.params.getDigestSize();
            int n3 = this.params.getWOTSPlus().getParams().getLen();
            int n4 = this.params.getHeight();
            int n5 = n3 * n2;
            int n6 = n4 * n2;
            this.index = Pack.bigEndianToInt(byArray, 0);
            this.random = XMSSUtil.extractBytesAtOffset(byArray, 4, n2);
            int n7 = n2 + 4;
            this.withReducedSignature(XMSSUtil.extractBytesAtOffset(byArray, n7, n5 + n6));
            return this;
        }

        @Override
        public XMSSSignature build() {
            return new XMSSSignature(this);
        }
    }
}

