/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.pqc.asn1.McEliecePrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.io.IOException;
import java.security.PrivateKey;

public class BCMcEliecePrivateKey
implements CipherParameters,
PrivateKey {
    private static final long serialVersionUID = 1L;
    private McEliecePrivateKeyParameters params;

    public BCMcEliecePrivateKey(McEliecePrivateKeyParameters mcEliecePrivateKeyParameters) {
        this.params = mcEliecePrivateKeyParameters;
    }

    @Override
    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public GF2mField getField() {
        return this.params.getField();
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.params.getGoppaPoly();
    }

    public GF2Matrix getSInv() {
        return this.params.getSInv();
    }

    public Permutation getP1() {
        return this.params.getP1();
    }

    public Permutation getP2() {
        return this.params.getP2();
    }

    public GF2Matrix getH() {
        return this.params.getH();
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.params.getQInv();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCMcEliecePrivateKey)) {
            return false;
        }
        BCMcEliecePrivateKey bCMcEliecePrivateKey = (BCMcEliecePrivateKey)object;
        return this.getN() == bCMcEliecePrivateKey.getN() && this.getK() == bCMcEliecePrivateKey.getK() && this.getField().equals(bCMcEliecePrivateKey.getField()) && this.getGoppaPoly().equals(bCMcEliecePrivateKey.getGoppaPoly()) && this.getSInv().equals(bCMcEliecePrivateKey.getSInv()) && this.getP1().equals(bCMcEliecePrivateKey.getP1()) && this.getP2().equals(bCMcEliecePrivateKey.getP2());
    }

    public int hashCode() {
        int n2 = this.params.getK();
        n2 = n2 * 37 + this.params.getN();
        n2 = n2 * 37 + this.params.getField().hashCode();
        n2 = n2 * 37 + this.params.getGoppaPoly().hashCode();
        n2 = n2 * 37 + this.params.getP1().hashCode();
        n2 = n2 * 37 + this.params.getP2().hashCode();
        return n2 * 37 + this.params.getSInv().hashCode();
    }

    @Override
    public byte[] getEncoded() {
        PrivateKeyInfo privateKeyInfo;
        Object object;
        McEliecePrivateKey mcEliecePrivateKey = new McEliecePrivateKey(this.params.getN(), this.params.getK(), this.params.getField(), this.params.getGoppaPoly(), this.params.getP1(), this.params.getP2(), this.params.getSInv());
        try {
            object = new AlgorithmIdentifier(PQCObjectIdentifiers.mcEliece);
            privateKeyInfo = new PrivateKeyInfo((AlgorithmIdentifier)object, mcEliecePrivateKey);
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            byte[] byArray = privateKeyInfo.getEncoded();
            object = byArray;
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

